/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags20x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag245
extends DataFieldDefinition {
    private static Tag245 uniqueInstance;

    private Tag245() {
        this.initialize();
        this.postCreation();
    }

    public static Tag245 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag245();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "245";
        this.label = "Title Statement";
        this.bibframeTag = "Title";
        this.cardinality = Cardinality.Nonrepeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd245.html";
        this.setCompilanceLevels("M", "M");
        this.ind1 = new Indicator("Title added entry").setCodes("0", "No added entry", "1", "Added entry").setMqTag("titleAddedEntry").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator("Nonfiling characters").setCodes("0", "No nonfiling characters", "1-9", "Number of nonfiling characters").setMqTag("nonfilingCharacters").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementSort);
        this.ind2.getCode("1-9").setRange(true);
        this.setSubfieldsWithCardinality("a", "Title", "NR", "b", "Remainder of title", "NR", "c", "Statement of responsibility, etc.", "NR", "f", "Inclusive dates", "NR", "g", "Bulk dates", "NR", "h", "Medium", "NR", "k", "Form", "R", "n", "Number of part/section of a work", "R", "p", "Name of part/section of a work", "R", "s", "Version", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("mainTitle").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M", "M");
        this.getSubfield("b").setBibframeTag("subtitle").setCompilanceLevels("A");
        this.getSubfield("c").setBibframeTag("responsibilityStatement").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("f").setBibframeTag("originDate").setMqTag("inclusiveDates").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("g").setBibframeTag("originDate").setMqTag("bulkDates").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("h").setBibframeTag("genreForm").setMqTag("medium").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("k").setMqTag("form").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("n").setBibframeTag("partNumber").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("p").setBibframeTag("partName").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("s").setMqTag("version").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("d", "Designation of section/part/series (SE) [OBSOLETE, 1979]", "e", "Name of part/section/series (SE) [OBSOLETE, 1979]");
    }
}

