/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags20x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag243
extends DataFieldDefinition {
    private static Tag243 uniqueInstance;

    private Tag243() {
        this.initialize();
        this.postCreation();
    }

    public static Tag243 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag243();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "243";
        this.label = "Collective Uniform Title";
        this.bibframeTag = "CollectiveTitle";
        this.cardinality = Cardinality.Nonrepeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd243.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Uniform title printed or displayed").setCodes("0", "Not printed or displayed", "1", "Printed or displayed").setHistoricalCodes("2", "Not printed on card, title added entry (MU) [USMARC only] [OBSOLETE, 1993] / Selections (extracts) [CAN/MARC only] [OBSOLETE]", "3", "Printed on card, title added entry (MU) [USMARC only] [OBSOLETE, 1993] / Other collective titles [CAN/MARC only] [OBSOLETE]").setMqTag("printedOrDisplayed").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator("Nonfiling characters").setCodes("0-9", "Number of nonfiling characters").setMqTag("nonfilingCharacters").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementSort);
        this.ind2.getCode("0-9").setRange(true);
        this.setSubfieldsWithCardinality("a", "Uniform title", "NR", "d", "Date of treaty signing", "R", "f", "Date of a work", "NR", "g", "Miscellaneous information", "R", "h", "Medium", "NR", "k", "Form subheading", "R", "l", "Language of a work", "NR", "m", "Medium of performance for music", "R", "n", "Number of part/section of a work", "R", "o", "Arranged statement for music", "NR", "p", "Name of part/section of a work", "R", "r", "Key for music", "NR", "s", "Version", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("mainTitle").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("d").setMqTag("dateOfTreaty").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("dateOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("miscellaneous").setCompilanceLevels("O");
        this.getSubfield("h").setMqTag("medium").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("k").setMqTag("formSubheading").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("l").setMqTag("languageOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("mediumOfPerformance").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("n").setBibframeTag("partNumber").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("o").setMqTag("arrangedStatement").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("p").setMqTag("nameOfPart").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("r").setMqTag("keyForMusic").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("s").setBibframeTag("version").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

