/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags1xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.NameAndTitleAuthoritySourceCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.RelatorCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag111
extends DataFieldDefinition {
    private static Tag111 uniqueInstance;

    private Tag111() {
        this.initialize();
        this.postCreation();
    }

    public static Tag111 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag111();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "111";
        this.label = "Main Entry - Meeting Name";
        this.mqTag = "MainMeetingName";
        this.cardinality = Cardinality.Nonrepeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd111.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator("Type of meeting name entry element").setCodes("0", "Inverted name", "1", "Jurisdiction name", "2", "Name in direct order").setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess, FRBRFunction.ManagementSort);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Meeting name or jurisdiction name as entry element", "NR", "c", "Location of meeting", "R", "d", "Date of meeting", "NR", "e", "Subordinate unit", "R", "f", "Date of a work", "NR", "g", "Miscellaneous information", "R", "j", "Relator term", "R", "k", "Form subheading", "R", "l", "Language of a work", "NR", "n", "Number of part/section/meeting", "R", "p", "Name of part/section of a work", "R", "q", "Name of meeting following jurisdiction name entry element", "NR", "t", "Title of a work", "NR", "u", "Affiliation", "NR", "0", "Authority record control number or standard number", "R", "2", "Source of heading or term", "NR", "4", "Relationship", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(NameAndTitleAuthoritySourceCodes.getInstance());
        this.getSubfield("4").setCodeList(RelatorCodes.getInstance());
        this.getSubfield("0").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M", "M");
        this.getSubfield("c").setMqTag("locationOfMeeting").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A", "A");
        this.getSubfield("d").setMqTag("dates").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A", "A");
        this.getSubfield("e").setMqTag("subordinateUnit").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A", "A");
        this.getSubfield("f").setMqTag("dateOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("miscellaneous").setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("relatorTerm").setCompilanceLevels("O");
        this.getSubfield("k").setMqTag("formSubheading").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("l").setMqTag("language").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("numberOfPart").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A", "A");
        this.getSubfield("p").setMqTag("nameOfPart").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("q").setMqTag("followingName").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("t").setMqTag("titleOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("u").setMqTag("affiliation").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setCompilanceLevels("O");
        this.getSubfield("2").setMqTag("source");
        this.getSubfield("4").setMqTag("relatorCode").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O", "A");
        this.getSubfield("6").setMqTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR"), new SubfieldDefinition("9", "NKCR Authority field - tracing form", "NR")));
        this.sourceSpecificationType = SourceSpecificationType.Subfield2;
    }
}

