/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.ClassificationSchemeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag086
extends DataFieldDefinition {
    private static Tag086 uniqueInstance;

    private Tag086() {
        this.initialize();
        this.postCreation();
    }

    public static Tag086 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag086();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "086";
        this.label = "Government Document Classification Number";
        this.bibframeTag = "Classification";
        this.mqTag = "GovernmentDocumentClassification";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd086.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Number source").setCodes(" ", "Source specified in subfield $2", "0", "Superintendent of Documents Classification System", "1", "Government of Canada Publications: Outline of Classification").setHistoricalCodes("0", "United States", "1", "Canada", "2-9", "Reserved").setMqTag("numberSource").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator().setHistoricalCodes(" ", "when first indicator is not \"1\"", "0", "IC cat. no.", "1", "Cat. IC, no.", "2", "QP cat. no.", "3", "Cat. IR, no.", "4", "DSS cat. no.", "5", "Cat. MAS, no.");
        this.setSubfieldsWithCardinality("a", "Classification number", "NR", "z", "Canceled/invalid classification number", "R", "2", "Number source", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(ClassificationSchemeSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("z").setMqTag("canceled").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.sourceSpecificationType = SourceSpecificationType.Indicator1IsSpaceAndSubfield2;
    }
}

