/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag085
extends DataFieldDefinition {
    private static Tag085 uniqueInstance;

    private Tag085() {
        this.initialize();
        this.postCreation();
    }

    public static Tag085 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag085();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "085";
        this.label = "Synthesized Classification Number Components";
        this.mqTag = "SynthesizedClassificationNumber";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd085.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Number where instructions are found-single number or beginning number of span", "R", "b", "Base number", "R", "c", "Classification number-ending number of span", "R", "f", "Facet designator", "R", "r", "Root number", "R", "s", "Digits added from classification number in schedule or external table", "R", "t", "Digits added from internal subarrangement or add table", "R", "u", "Number being analyzed", "R", "v", "Number in internal subarrangement or add table where instructions are found", "R", "w", "Table identification-Internal subarrangement or add table", "R", "y", "Table sequence number for internal subarrangement or add table", "R", "z", "Table identification", "R", "0", "Authority record control number or standard number", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("classificationPortion").setCompilanceLevels("O");
        this.getSubfield("b").setMqTag("baseNumber").setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("endingNumber").setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("facet").setCompilanceLevels("A");
        this.getSubfield("r").setMqTag("rootNumber").setCompilanceLevels("A");
        this.getSubfield("s").setMqTag("fromClassification").setCompilanceLevels("A");
        this.getSubfield("t").setMqTag("subarrangement").setCompilanceLevels("A");
        this.getSubfield("u").setMqTag("analyzedNumber").setCompilanceLevels("O");
        this.getSubfield("v").setMqTag("numberInSubarrangement").setCompilanceLevels("A");
        this.getSubfield("w").setMqTag("tableIdentificationInternal").setCompilanceLevels("A");
        this.getSubfield("y").setMqTag("tableSequenceNumber").setCompilanceLevels("A");
        this.getSubfield("z").setMqTag("tableIdentification").setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber");
        this.getSubfield("6").setBibframeTag("linkage").setCompilanceLevels("O");
        this.getSubfield("8").setMqTag("fieldLink").setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
    }
}

