/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag082
extends DataFieldDefinition {
    private static Tag082 uniqueInstance;

    private Tag082() {
        this.initialize();
        this.postCreation();
    }

    public static Tag082 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag082();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "082";
        this.label = "Dewey Decimal Classification Number";
        this.bibframeTag = "ClassificationDdc";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd082.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Type of edition").setCodes("0", "Full edition", "1", "Abridged edition", "7", "Other edition specified in subfield $2").setHistoricalCodes(" ", "No edition information recorded (BK, MU, VM, SE) [OBSOLETE]", "2", "Abridged NST version (BK, MU, VM, SE) [OBSOLETE]").setMqTag("editionType").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator("Source of classification number").setCodes(" ", "No information provided", "0", "Assigned by LC", "4", "Assigned by agency other than LC").setHistoricalCodes(" ", "No information provided [OBSOLETE] [USMARC only, BK, CF, MU, VM, SE]").setMqTag("classificationSource").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Classification number", "R", "b", "Item number", "NR", "m", "Standard or optional designation", "NR", "q", "Assigning agency", "NR", "2", "Edition number", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("q").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("classificationPortion").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("b").setBibframeTag("itemPortion").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("standard").setCompilanceLevels("M");
        this.getSubfield("q").setBibframeTag("source").setCompilanceLevels("O");
        this.getSubfield("2").setBibframeTag("edition").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("M");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("b", "DDC number-abridged NST version (SE) [OBSOLETE]");
    }
}

