/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag070
extends DataFieldDefinition {
    private static Tag070 uniqueInstance;

    private Tag070() {
        this.initialize();
        this.postCreation();
    }

    public static Tag070 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag070();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "070";
        this.label = "National Agricultural Library Call Number";
        this.bibframeTag = "Classification";
        this.mqTag = "NalCallNumber";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd070.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator(" collection").setCodes("0", "Item is in NAL", "1", "Item is not in NAL").setMqTag("existenceInNAL").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain);
        this.ind2 = new Indicator().setHistoricalCodes("0", "No series involved", "1", "Main series", "2", "Subseries", "3", "Sub-subseries");
        this.setSubfieldsWithCardinality("a", "Classification number", "R", "b", "Item number", "NR", "0", "Authority record control number or standard number", "R", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setBibframeTag("classificationPortion").setMqTag("classification").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("b").setBibframeTag("itemPortion").setMqTag("item").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
    }
}

