/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag061
extends DataFieldDefinition {
    private static Tag061 uniqueInstance;

    private Tag061() {
        this.initialize();
        this.postCreation();
    }

    public static Tag061 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag061();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "061";
        this.label = "National Library of Medicine Copy Statement";
        this.mqTag = "NlmCopy";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd061.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator().setHistoricalCodes("0", "No series involved", "1", "Main series", "2", "Subseries", "3", "Sub-subseries");
        this.setSubfieldsWithCardinality("a", "Classification number", "R", "b", "Item number", "NR", "c", "Copy information", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setMqTag("classificationPortion").setMqTag("classification").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("itemPortion").setMqTag("item").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("copy").setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

