/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.MusicalInstrumentationAndVoiceSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.MusicalInstrumentsOrVoicesCodes;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag048
extends DataFieldDefinition {
    private static Tag048 uniqueInstance;

    private Tag048() {
        this.initialize();
        this.postCreation();
    }

    public static Tag048 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag048();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "048";
        this.label = "Number of Musical Instruments or Voices Codes";
        this.mqTag = "NumberOfMusicalInstrumentsOrVoices";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd048.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator().setHistoricalCodes("0", "One performer to a part", "1", "More than one performer to some parts or all parts", "2", "Soloist with type of ensemble referred to in 1 above");
        this.ind2 = new Indicator("Source of code").setCodes(" ", "MARC code", "7", "Source specified in subfield $2").setMqTag("sourceOfCode");
        this.setSubfieldsWithCardinality("a", "Performer or ensemble", "R", "b", "Soloist", "R", "2", "Source of code", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setCodeList(MusicalInstrumentsOrVoicesCodes.getInstance());
        this.getSubfield("b").setCodeList(MusicalInstrumentsOrVoicesCodes.getInstance());
        this.getSubfield("2").setCodeList(MusicalInstrumentationAndVoiceSourceCodes.getInstance());
        this.getSubfield("a").setMqTag("performerOrEnsemble").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("soloist").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setCompilanceLevels("O");
    }
}

