/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.LanguageCodeAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.LanguageCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag041
extends DataFieldDefinition {
    private static Tag041 uniqueInstance;

    private Tag041() {
        this.initialize();
        this.postCreation();
    }

    public static Tag041 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag041();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "041";
        this.label = "Language Code";
        this.bibframeTag = "Language";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd041.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Translation indication").setCodes(" ", "No information provided", "0", "Item not a translation/does not include a translation", "1", "Item is or includes a translation").setMqTag("translationIndication").setFrbrFunctions(FRBRFunction.DiscoverySelect);
        this.ind2 = new Indicator("Source of code").setCodes(" ", "MARC language code", "7", "Source specified in subfield $2").setMqTag("sourceOfCode").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Language code of text/sound track or separate title", "R", "b", "Language code of summary or abstract", "R", "d", "Language code of sung or spoken text", "R", "e", "Language code of librettos", "R", "f", "Language code of table of contents", "R", "g", "Language code of accompanying material other than librettos", "R", "h", "Language code of original", "R", "j", "Language code of subtitles or captions", "R", "k", "Language code of intermediate translations", "R", "m", "Language code of original accompanying materials other than librettos", "R", "n", "Language code of original libretto", "R", "2", "Source of code", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("b").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("d").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("e").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("f").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("g").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("h").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("j").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("k").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("m").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("n").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("2").setCodeList(LanguageCodeAndTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseInterpret).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("ofSummary").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("ofSungOrSpokenText").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("ofLibrettos").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("ofTableOfContents").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("O");
        this.getSubfield("g").setMqTag("ofAccompanyingMaterial").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("ofOriginal").setFrbrFunctions(FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("ofSubtitles").setCompilanceLevels("A");
        this.getSubfield("k").setMqTag("ofTranslations");
        this.getSubfield("m").setMqTag("ofOriginalAccompanyingMaterial");
        this.getSubfield("n").setMqTag("ofOriginalLibretto");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("c", "Languages of separate titles (VM) [OBSOLETE, 1972], Languages of available translation (SE) [OBSOLETE, 1977]");
    }
}

