/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.SubjectHeadingAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag033
extends DataFieldDefinition {
    private static Tag033 uniqueInstance;

    private Tag033() {
        this.initialize();
        this.postCreation();
    }

    public static Tag033 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag033();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "033";
        this.label = "Date/Time and Place of an Event";
        this.bibframeTag = "Capture";
        this.mqTag = "EventDateTimeAndPlace";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd033.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Type of date in subfield $a").setCodes(" ", "No date information", "0", "Single date", "1", "Multiple single dates", "2", "Range of dates").setMqTag("dateType").setFrbrFunctions(FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator("Type of event").setCodes(" ", "No information provided", "0", "Capture", "1", "Broadcast", "2", "Finding").setMqTag("eventType").setFrbrFunctions(FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Formatted date/time", "R", "b", "Geographic classification area code", "R", "c", "Geographic classification subarea code", "R", "p", "Place of event", "R", "0", "Authority record control number", "R", "2", "Source of term", "R", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(SubjectHeadingAndTermSourceCodes.getInstance());
        this.getSubfield("0").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("date").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("b").setBibframeTag("place").setMqTag("area").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("subarea").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("p").setBibframeTag("place").setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setCompilanceLevels("O");
        this.getSubfield("2").setMqTag("source");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

