/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.Code;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import java.util.Arrays;

public class Tag028
extends DataFieldDefinition {
    private static Tag028 uniqueInstance;

    private Tag028() {
        this.initialize();
        this.postCreation();
    }

    public static Tag028 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag028();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "028";
        this.label = "Publisher or Distributor Number";
        this.mqTag = "PublisherNumber";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd028.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator("Type of number").setCodes("0", "Issue number", "1", "Matrix number", "2", "Plate number", "3", "Other music publisher number", "4", "Video recording publisher number", "5", "Other publisher number", "6", "Distributor number").putVersionSpecificCodes(MarcVersion.SZTE, Arrays.asList(new Code(" ", "Not specified"))).setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.ind1.getCode("0").setBibframeTag("AudioIssueNumber");
        this.ind1.getCode("1").setBibframeTag("MatrixNumber");
        this.ind1.getCode("2").setBibframeTag("MusicPlate");
        this.ind1.getCode("3").setBibframeTag("MusicPublisherNumber");
        this.ind1.getCode("4").setBibframeTag("VideoRecordingNumber");
        this.ind1.getCode("5").setBibframeTag("PublisherNumber");
        this.ind2 = new Indicator("Note/added entry controller").setCodes("0", "No note, no added entry", "1", "Note, added entry", "2", "Note, no added entry", "3", "No note, added entry").setMqTag("noteController").setFrbrFunctions(FRBRFunction.ManagementDisplay);
        this.setSubfieldsWithCardinality("a", "Publisher or distributor number", "NR", "b", "Source", "NR", "q", "Qualifying information", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M", "M");
        this.getSubfield("b").setBibframeTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("M", "M");
        this.getSubfield("q").setBibframeTag("qualifier");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

