/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.CopyrightAndLegalDepositNumberSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag017
extends DataFieldDefinition {
    private static Tag017 uniqueInstance;

    private Tag017() {
        this.initialize();
        this.postCreation();
    }

    public static Tag017 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag017();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "017";
        this.label = "Copyright or Legal Deposit Number";
        this.bibframeTag = "CopyrightNumber";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd017.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator().setHistoricalCodes("0", "United States [OBSOLETE]", "1", "Canada [OBSOLETE]", "2", "France [OBSOLETE] [CAN/MARC only]");
        this.ind2 = new Indicator("Display constant controller").setCodes(" ", "Copyright or legal deposit number", "8", "No display constant generated").setMqTag("displayConstant").setFrbrFunctions(FRBRFunction.ManagementDisplay);
        this.setSubfieldsWithCardinality("a", "Copyright or legal deposit number", "R", "b", "Assigning agency", "NR", "d", "Date", "NR", "i", "Display text", "NR", "z", "Canceled/invalid copyright or legal deposit number", "R", "2", "Source", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(CopyrightAndLegalDepositNumberSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("b").setBibframeTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("M");
        this.getSubfield("d").setBibframeTag("date").setCompilanceLevels("O");
        this.getSubfield("i").setBibframeTag("note").setCompilanceLevels("O");
        this.getSubfield("z").setMqTag("canceled").setCompilanceLevels("A");
        this.getSubfield("2").setBibframeTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

