/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.CountryCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.YYYYMMDDDateParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag013
extends DataFieldDefinition {
    private static Tag013 uniqueInstance;

    private Tag013() {
        this.initialize();
        this.postCreation();
    }

    public static Tag013 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag013();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "013";
        this.label = "Patent Control Information";
        this.mqTag = "PatentControl";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd013.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Number", "NR", "b", "Country", "NR", "c", "Type of number", "NR", "d", "Date", "R", "e", "Status", "R", "f", "Party to document", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("b").setCodeList(CountryCodes.getInstance());
        this.getSubfield("f").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("d").setContentParser(YYYYMMDDDateParser.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("number").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("country").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("date").setCompilanceLevels("O");
        this.getSubfield("e").setMqTag("status").setCompilanceLevels("O");
        this.getSubfield("f").setMqTag("partyToDocument").setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setCompilanceLevels("O");
    }
}

