/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag010
extends DataFieldDefinition {
    private static Tag010 uniqueInstance;

    private Tag010() {
        this.initialize();
        this.postCreation();
    }

    public static Tag010 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag010();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "010";
        this.label = "Library of Congress Control Number";
        this.bibframeTag = "IdentifiedBy/Lccn";
        this.cardinality = Cardinality.Nonrepeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd010.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "LC control number", "NR", "b", "NUCMC control number", "R", "z", "Canceled/invalid LC control number", "R", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setBibframeTag("rdf:value").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("b").setMqTag("numcControlNumber").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("z").setMqTag("canceled").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

