/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.nkcrtags;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.NameAndTitleAuthoritySourceCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.RelatorCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISSNValidator;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag983
extends DataFieldDefinition {
    private static Tag983 uniqueInstance;

    private Tag983() {
        this.initialize();
        this.postCreation();
    }

    public static Tag983 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag983();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "983";
        this.label = "Added Entry - Personal Name";
        this.mqTag = "AddedPersonalName";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.nkp.cz/o-knihovne/odborne-cinnosti/zpracovani-fondu/informativni-materialy/blok-9xxuni-m21";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Type of personal name entry element").setCodes("0", "Forename", "1", "Surname", "3", "Family name").setMqTag("nameType").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess, FRBRFunction.ManagementSort);
        this.ind2 = new Indicator("Type of added entry").setCodes(" ", "No information provided", "2", "Analytical entry").setMqTag("entryType").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Personal name", "NR", "b", "Numeration", "NR", "c", "Titles and other words associated with a name", "R", "d", "Dates associated with a name", "NR", "e", "Relator term", "R", "f", "Date of a work", "NR", "g", "Miscellaneous information", "R", "h", "Medium", "NR", "i", "Relationship information", "R", "j", "Attribution qualifier", "R", "k", "Form subheading", "R", "l", "Language of a work", "NR", "m", "Medium of performance for music", "R", "n", "Number of part/section of a work", "R", "o", "Arranged statement for music", "NR", "p", "Name of part/section of a work", "R", "q", "Fuller form of name", "NR", "r", "Key for music", "NR", "s", "Version", "NR", "t", "Title of a work", "NR", "u", "Affiliation", "NR", "x", "International Standard Serial Number", "NR", "0", "Authority record control number or standard number", "R", "2", "Source of heading or term", "NR", "3", "Materials specified", "NR", "4", "Relationship", "R", "5", "K\u00f3d instituce:signatura exempl\u00e1\u0159e", "NR", "6", "Linkage", "NR", "7", "NKCR Authority ID", "NR", "8", "(M\u00edsto) a datum z\u00edsk\u00e1n\u00ed knihy (z exlibris, supralibros apod.)", "R", "9", "Slovn\u00ed vyj\u00e1d\u0159en\u00ed k\u00f3du role", "NR");
        this.getSubfield("2").setCodeList(NameAndTitleAuthoritySourceCodes.getInstance());
        this.getSubfield("4").setCodeList(RelatorCodes.getInstance());
        this.getSubfield("0").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("x").setValidator(ISSNValidator.getInstance());
        this.getSubfield("a").setMqTag("personalName").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("numeration").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("titlesAndWords").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("dates").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("relatorTerm").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("f").setMqTag("dateOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("miscellaneous").setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("medium").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("i").setMqTag("relationship").setCompilanceLevels("O");
        this.getSubfield("j").setMqTag("attributionQualifier").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("k").setMqTag("formSubheading").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("l").setMqTag("language").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("mediumOfPerformance").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("numberOfPart").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("o").setMqTag("arrangedStatement").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("p").setMqTag("nameOfPart").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("q").setMqTag("fullerForm").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("r").setMqTag("keyForMusic").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("s").setMqTag("version").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("t").setMqTag("titleOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("u").setMqTag("affiliation").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("x").setMqTag("issn").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setCompilanceLevels("O");
        this.getSubfield("2").setMqTag("source");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("4").setMqTag("relatorCode").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("6").setMqTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.sourceSpecificationType = SourceSpecificationType.Subfield2;
    }
}

