/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.holdings;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.HoldingSchemeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag866
extends DataFieldDefinition {
    private static Tag866 uniqueInstance;

    private Tag866() {
        this.initialize();
        this.postCreation();
    }

    public static Tag866 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag866();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "866";
        this.label = "Textual Holdings-Basic Bibliographic Unit";
        this.mqTag = "TextualHoldingsBasicBibliographicUnit";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/hd866.html";
        this.ind1 = new Indicator("Field encoding level").setCodes(" ", "No information provided", "3", "Holdings level 3", "4", "Holdings level 4", "5", "Holdings level 4 with piece designation").setMqTag("fieldEncodingLevel").setFrbrFunctions(FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator("Type of notation").setCodes("0", "Non-standard", "1", "ANSI/NISO Z39.71 or ISO 10324", "2", "ANSI Z39.42", "7", "Source specified in subfield $2").setMqTag("notationType").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Textual holdings", "NR", "x", "Nonpublic note", "R", "z", "Public note", "R", "2", "Source of notation", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(HoldingSchemeSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value");
        this.getSubfield("6").setMqTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
    }
}

