/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.bltags;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISSNValidator;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class TagLCS
extends DataFieldDefinition {
    private static TagLCS uniqueInstance;

    private TagLCS() {
        this.initialize();
        this.postCreation();
    }

    public static TagLCS getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new TagLCS();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "LCS";
        this.label = "Library of Congress Series Statement";
        this.mqTag = "LoCSeriesStatement";
        this.cardinality = Cardinality.Repeatable;
        this.obsolete = true;
        this.ind1 = new Indicator("Specifies whether series is traced").setCodes("0", "Series not traced").setMqTag("seriesIsTraced");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Series statement", "R", "l", "Library of Congress call number", "NR", "v", "Volume/sequential designation", "R", "x", "International Standard Serial Number", "R", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("x").setValidator(ISSNValidator.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value");
        this.getSubfield("l").setMqTag("lccn");
        this.getSubfield("v").setMqTag("volume");
        this.getSubfield("x").setMqTag("issn");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("6").setBibframeTag("linkage");
        this.getSubfield("8").setMqTag("fieldLink");
    }
}

