/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.bltags;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class TagCFI
extends DataFieldDefinition {
    private static TagCFI uniqueInstance;

    private TagCFI() {
        this.initialize();
        this.postCreation();
    }

    public static TagCFI getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new TagCFI();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "CFI";
        this.label = "Copyright Fee Information";
        this.mqTag = "CopyrightFeeInformation";
        this.cardinality = Cardinality.Repeatable;
        this.ind1 = new Indicator("Fee").setCodes("0", "Current fee", "1", "Pending fee", "2", "Historical fee").setMqTag("fee");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Fee and currency", "NR", "b", "Copyright licensing agency or publisher name etc.", "NR", "c", "Licence number", "NR", "d", "Authorised users", "NR", "e", "Commencement date", "NR", "f", "Article rate (Base rate)", "NR", "g", "Page rate", "NR", "h", "Fee source", "NR", "i", "Copyright excluded", "NR", "u", "Uniform Resource Identifier", "NR", "3", "Materials specified", "NR", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setMqTag("fee");
        this.getSubfield("b").setMqTag("copyright");
        this.getSubfield("c").setMqTag("licenceNumber");
        this.getSubfield("d").setMqTag("authorisedUsers");
        this.getSubfield("e").setMqTag("commencementDate");
        this.getSubfield("f").setMqTag("articleRate");
        this.getSubfield("g").setMqTag("pageRate");
        this.getSubfield("h").setCodes("A", "Average", "BL", "British Library", "C", "CLA (Copyright Licensing Agency)", "P", "Publisher", "Z", "Zero").setMqTag("feeSource");
        this.getSubfield("i").setMqTag("copyrightExcluded");
        this.getSubfield("u").setMqTag("uri");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("5").setCodes("Uk", "Uk").setMqTag("institutionToWhichFieldApplies");
        this.getSubfield("6").setMqTag("linkage");
        this.getSubfield("8").setMqTag("fieldLink");
    }
}

