/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general.validator;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.definition.ValidatorResponse;
import de.gwdg.metadataqa.marc.definition.general.validator.SubfieldValidator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang.StringUtils;

public class DateValidator
implements SubfieldValidator,
Serializable {
    private final String pattern;
    private final DateTimeFormatter formatter;

    public DateValidator(String rawPattern) {
        this.pattern = rawPattern;
        this.formatter = DateTimeFormatter.ofPattern(rawPattern);
    }

    @Override
    public ValidatorResponse isValid(MarcSubfield subfield) {
        ValidatorResponse response = new ValidatorResponse();
        SubfieldDefinition definition = subfield.getDefinition();
        String descriptionUrl = definition != null ? definition.getParent().getDescriptionUrl() : null;
        String value = subfield.getValue();
        if (StringUtils.isNotBlank((String)value)) {
            try {
                LocalDate localDate = LocalDate.parse(value, this.formatter);
            }
            catch (DateTimeParseException e) {
                response.addValidationError(new ValidationError(subfield.getRecord().getId(), subfield.getDefinition().getPath(), ValidationErrorType.SUBFIELD_PATTERN_MISMATCH, String.format("mismatched '%s' against '%s': %s", value, this.pattern, e.getMessage()), descriptionUrl));
            }
        } else {
            response.addValidationError(new ValidationError(subfield.getRecord().getId(), subfield.getDefinition().getPath(), ValidationErrorType.SUBFIELD_PATTERN_MISMATCH, String.format("mismatched '%s' against '%s'", value, this.pattern), descriptionUrl));
        }
        return response;
    }
}

