/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general.indexer.subject;

import de.gwdg.metadataqa.marc.DataField;
import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.cli.ClassificationAnalysis;
import de.gwdg.metadataqa.marc.utils.keygenerator.DataFieldKeyGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

abstract class SubjectIndexer {
    private static final Logger logger = Logger.getLogger(ClassificationAnalysis.class.getCanonicalName());

    SubjectIndexer() {
    }

    protected void addUniqueValues(List<String> values, MarcSubfield subfield) {
        String value = subfield.resolve();
        if (!values.contains(value)) {
            values.add(value);
        }
    }

    protected class KeyValuesExtractor {
        private DataField dataField;
        private DataFieldKeyGenerator keyGenerator;
        private String schemaAbbreviation;
        private String key;
        private List<String> values;
        private boolean success = false;

        public KeyValuesExtractor(DataField dataField, DataFieldKeyGenerator keyGenerator, String schemaAbbreviation) {
            this.dataField = dataField;
            this.keyGenerator = keyGenerator;
            this.schemaAbbreviation = schemaAbbreviation;
        }

        public String getKey() {
            return this.key;
        }

        public List<String> getValues() {
            return this.values;
        }

        public KeyValuesExtractor invoke() {
            List<MarcSubfield> subfields = this.dataField.getSubfield("a");
            if (subfields == null || subfields.isEmpty()) {
                this.success = false;
                if (!this.dataField.getDefinition().getTag().equals("852")) {
                    logger.warning("No subfield a in the field: " + this.dataField.toString());
                }
            } else {
                this.key = this.keyGenerator.forSubfield(subfields.get(0)) + "_" + Utils.solarize(this.schemaAbbreviation);
                this.values = new ArrayList<String>();
                for (MarcSubfield subfield : subfields) {
                    SubjectIndexer.this.addUniqueValues(this.values, subfield);
                }
                this.success = true;
            }
            return this;
        }

        public boolean hadSuccess() {
            return this.success;
        }
    }
}

