/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils;

import de.gwdg.metadataqa.marc.Leader;
import de.gwdg.metadataqa.marc.MarcFactory;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.cli.processor.MarcFileProcessor;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.utils.ReadMarc;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.time.LocalTime;
import java.util.logging.Logger;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.solr.client.solrj.SolrServerException;
import org.marc4j.MarcException;
import org.marc4j.MarcReader;
import org.marc4j.marc.Record;

public class RecordIterator {
    private static final Logger logger = Logger.getLogger(RecordIterator.class.getCanonicalName());
    private static Options options;
    private MarcFileProcessor processor;

    public RecordIterator(MarcFileProcessor processor) {
        this.processor = processor;
    }

    public void start() {
        long start = System.currentTimeMillis();
        this.processor.beforeIteration();
        MarcVersion marcVersion = this.processor.getParameters().getMarcVersion();
        Leader.Type defaultRecordType = this.processor.getParameters().getDefaultRecordType();
        boolean fixAlephseq = this.processor.getParameters().fixAlephseq();
        boolean isAlephseq = this.processor.getParameters().isAlephseq();
        boolean isMarcxml = this.processor.getParameters().isMarcxml();
        boolean isLineSeparated = this.processor.getParameters().isLineSeparated();
        DecimalFormat decimalFormat = new DecimalFormat();
        if (this.processor.getParameters().doLog()) {
            logger.info("marcVersion: " + marcVersion.getCode() + ", " + marcVersion.getLabel());
        }
        String[] inputFileNames = this.processor.getParameters().getArgs();
        int i = 0;
        String lastKnownId = "";
        for (String inputFileName : inputFileNames) {
            if (!this.processor.readyToProcess()) break;
            Path path = Paths.get(inputFileName, new String[0]);
            String fileName = path.getFileName().toString();
            if (this.processor.getParameters().doLog()) {
                logger.info("processing: " + fileName);
            }
            try {
                MarcReader reader;
                this.processor.fileOpened(path);
                MarcReader marcReader = reader = isAlephseq ? ReadMarc.getAlephseqMarcReader(path.toString()) : ReadMarc.getReader(path.toString(), isMarcxml, isLineSeparated);
                while (reader.hasNext() && this.processor.readyToProcess()) {
                    Record marc4jRecord = null;
                    try {
                        marc4jRecord = reader.next();
                    }
                    catch (NegativeArraySizeException | NumberFormatException | MarcException e) {
                        logger.severe(String.format("MARC record parsing problem at record #%d (last known ID: %s): %s", i + 1, lastKnownId, e.getLocalizedMessage()));
                    }
                    catch (Exception e) {
                        logger.severe("another exception");
                        e.printStackTrace();
                    }
                    if (marc4jRecord == null || RecordIterator.isUnderOffset(this.processor.getParameters().getOffset(), ++i)) continue;
                    if (RecordIterator.isOverLimit(this.processor.getParameters().getLimit(), i)) break;
                    if (marc4jRecord.getControlNumber() == null) {
                        logger.severe("No record number at " + i + ", last known ID: " + lastKnownId);
                        System.err.println(marc4jRecord);
                        continue;
                    }
                    lastKnownId = marc4jRecord.getControlNumber();
                    if (this.processor.getParameters().hasId() && !marc4jRecord.getControlNumber().trim().equals(this.processor.getParameters().getId())) continue;
                    try {
                        this.processor.processRecord(marc4jRecord, i);
                        MarcRecord marcRecord = MarcFactory.createFromMarc4j(marc4jRecord, defaultRecordType, marcVersion, fixAlephseq);
                        try {
                            this.processor.processRecord(marcRecord, i);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (i % 100000 != 0 || !this.processor.getParameters().doLog()) continue;
                        logger.info(String.format("%s/%s (%s)", fileName, decimalFormat.format(i), marcRecord.getId()));
                    }
                    catch (IllegalArgumentException e) {
                        if (marc4jRecord.getControlNumber() == null) {
                            logger.severe("No record number at " + i);
                        }
                        if (this.processor.getParameters().doLog()) {
                            logger.severe(String.format("Error (illegal argument) with record '%s'. %s", marc4jRecord.getControlNumber(), e.getMessage()));
                        }
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        if (marc4jRecord.getControlNumber() == null) {
                            logger.severe("No record number at " + i);
                        }
                        if (this.processor.getParameters().doLog()) {
                            logger.severe(String.format("Error (general) with record '%s'. %s", marc4jRecord.getControlNumber(), e.getMessage()));
                        }
                        e.printStackTrace();
                    }
                }
                if (!this.processor.getParameters().doLog()) continue;
                logger.info(String.format("Finished processing file. Processed %s records.", decimalFormat.format(i)));
            }
            catch (SolrServerException ex) {
                if (this.processor.getParameters().doLog()) {
                    logger.severe(ex.toString());
                }
                System.exit(0);
            }
            catch (Exception ex) {
                if (this.processor.getParameters().doLog()) {
                    logger.severe("Other exception: " + ex.toString());
                    for (Record element : ex.getStackTrace()) {
                        System.err.println(element.toString());
                    }
                    Throwable exa = ex;
                    while (exa.getCause() != null) {
                        System.err.println("cause");
                        exa = exa.getCause();
                        for (StackTraceElement element : exa.getStackTrace()) {
                            System.err.println(element.toString());
                        }
                    }
                }
                ex.printStackTrace();
                System.exit(0);
            }
        }
        this.processor.afterIteration(i);
        long end = System.currentTimeMillis();
        long duration = (end - start) / 1000L;
        if (this.processor.getParameters().doLog()) {
            logger.info(String.format("Bye! It took: %s", LocalTime.MIN.plusSeconds(duration).toString()));
        }
    }

    private static boolean isOverLimit(int limit, int i) {
        return limit > -1 && i > limit;
    }

    private static boolean isUnderOffset(int offset, int i) {
        return offset > -1 && i < offset;
    }

    private static void printHelp(Options opions) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -cp metadata-qa-marc.jar de.gwdg.metadataqa.marc.cli.Validator [options] [file]", opions);
    }
}

