/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils;

import de.gwdg.metadataqa.marc.Code;
import de.gwdg.metadataqa.marc.cli.parameters.MappingParameters;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.CompilanceLevel;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.controlpositions.Control006Positions;
import de.gwdg.metadataqa.marc.definition.controlpositions.Control007Positions;
import de.gwdg.metadataqa.marc.definition.controlpositions.Control008Positions;
import de.gwdg.metadataqa.marc.definition.controlpositions.LeaderPositions;
import de.gwdg.metadataqa.marc.definition.general.codelist.CodeList;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control001Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control003Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control005Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control006Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control007Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control008Definition;
import de.gwdg.metadataqa.marc.utils.MarcTagLister;
import de.gwdg.metadataqa.marc.utils.keygenerator.DataFieldKeyGenerator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.minidev.json.JSONValue;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class MappingToJson {
    private static final Logger logger = Logger.getLogger(MappingToJson.class.getCanonicalName());
    private static final List<String> nonMarc21TagLibraries = Arrays.asList("oclctags", "fennicatags", "dnbtags", "sztetags", "genttags", "nkcrtags", "holdings");
    private boolean exportSubfieldCodes = false;
    private boolean exportSelfDescriptiveCodes = false;
    private Map<String, Object> mapping;
    private final Options options;
    private MappingParameters parameters;

    public MappingToJson(String[] args) throws ParseException {
        this.parameters = new MappingParameters(args);
        this.options = this.parameters.getOptions();
        this.exportSubfieldCodes = this.parameters.doExportSubfieldCodes();
        this.exportSelfDescriptiveCodes = this.parameters.doExportSelfDescriptiveCodes();
        this.mapping = new LinkedHashMap<String, Object>();
        this.mapping.put("$schema", "https://format.gbv.de/schema/avram/schema.json");
        this.mapping.put("title", "MARC 21 Format for Bibliographic Data.");
        this.mapping.put("description", "MARC 21 Format for Bibliographic Data.");
        this.mapping.put("url", "https://www.loc.gov/marc/bibliographic/");
    }

    public void setExportSubfieldCodes(boolean exportSubfieldCodes) {
        this.exportSubfieldCodes = exportSubfieldCodes;
    }

    public String toJson() {
        return JSONValue.toJSONString(this.mapping);
    }

    public void build() {
        String key;
        Map<String, Object> position;
        LinkedHashMap<String, LinkedHashMap<String, Map<String, Object>>> typeMap;
        LinkedHashMap fields = new LinkedHashMap();
        LinkedHashMap<String, Object> tag = new LinkedHashMap<String, Object>();
        tag.put("repeatable", false);
        LinkedHashMap<String, Map<String, Object>> positions = new LinkedHashMap<String, Map<String, Object>>();
        LeaderPositions leaderSubfields = LeaderPositions.getInstance();
        for (ControlfieldPositionDefinition controlfieldPositionDefinition : leaderSubfields.getPositionList()) {
            Map<String, Object> position2 = MappingToJson.controlPositionToJson(controlfieldPositionDefinition);
            String string = (String)position2.remove("position");
            positions.put(string, position2);
        }
        tag.put("positions", positions);
        fields.put("LDR", tag);
        List<DataFieldDefinition> simpleControlFields = Arrays.asList(Control001Definition.getInstance(), Control003Definition.getInstance(), Control005Definition.getInstance());
        for (DataFieldDefinition field : simpleControlFields) {
            tag = new LinkedHashMap();
            tag.put("tag", field.getTag());
            tag.put("label", field.getLabel());
            tag.put("repeatable", this.resolveCardinality(field.getCardinality()));
            fields.put(field.getTag(), tag);
        }
        tag = new LinkedHashMap();
        tag.put("tag", "006");
        tag.put("label", Control006Definition.getInstance().getLabel());
        tag.put("repeatable", this.resolveCardinality(Control006Definition.getInstance().getCardinality()));
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (String string : Control006Positions.getInstance().getPositions().keySet()) {
            typeMap = new LinkedHashMap<String, LinkedHashMap<String, Map<String, Object>>>();
            positions = new LinkedHashMap();
            for (ControlfieldPositionDefinition subfield : Control006Positions.getInstance().getPositions().get(string)) {
                position = MappingToJson.controlPositionToJson(subfield);
                key = (String)position.remove("position");
                positions.put(key, position);
            }
            typeMap.put("positions", positions);
            linkedHashMap.put(string, typeMap);
        }
        tag.put("types", linkedHashMap);
        fields.put("006", tag);
        tag = new LinkedHashMap();
        tag.put("tag", "007");
        tag.put("label", Control007Definition.getInstance().getLabel());
        tag.put("repeatable", this.resolveCardinality(Control007Definition.getInstance().getCardinality()));
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Map<String, Object>>>> linkedHashMap2 = new LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Map<String, Object>>>>();
        for (String string : Control007Positions.getInstance().getPositions().keySet()) {
            typeMap = new LinkedHashMap();
            positions = new LinkedHashMap();
            for (ControlfieldPositionDefinition subfield : Control007Positions.getInstance().getPositions().get(string)) {
                position = MappingToJson.controlPositionToJson(subfield);
                key = (String)position.remove("position");
                positions.put(key, position);
            }
            typeMap.put("positions", positions);
            linkedHashMap2.put(string, typeMap);
        }
        tag.put("types", linkedHashMap2);
        fields.put("007", tag);
        tag = new LinkedHashMap();
        tag.put("tag", "008");
        tag.put("label", Control008Definition.getInstance().getLabel());
        tag.put("repeatable", this.resolveCardinality(Control008Definition.getInstance().getCardinality()));
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Map<String, Object>>>> linkedHashMap3 = new LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Map<String, Object>>>>();
        for (String string : Control008Positions.getInstance().getPositions().keySet()) {
            typeMap = new LinkedHashMap();
            positions = new LinkedHashMap();
            for (ControlfieldPositionDefinition subfield : Control008Positions.getInstance().getPositions().get(string)) {
                position = MappingToJson.controlPositionToJson(subfield);
                key = (String)position.remove("position");
                positions.put(key, position);
            }
            typeMap.put("positions", positions);
            linkedHashMap3.put(string, typeMap);
        }
        tag.put("types", linkedHashMap3);
        fields.put("008", tag);
        for (Class clazz : MarcTagLister.listTags()) {
            if (MappingToJson.isNonMarc21Tag(clazz)) continue;
            try {
                Method getInstance = clazz.getMethod("getInstance", new Class[0]);
                DataFieldDefinition fieldTag = (DataFieldDefinition)getInstance.invoke((Object)clazz, new Object[0]);
                this.dataFieldToJson(fields, fieldTag);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.mapping.put("fields", fields);
    }

    private static boolean isNonMarc21Tag(Class<? extends DataFieldDefinition> tagClass) {
        boolean isNonMarc21Tag = false;
        for (String nonCore : nonMarc21TagLibraries) {
            if (!tagClass.getCanonicalName().contains(nonCore)) continue;
            isNonMarc21Tag = true;
            break;
        }
        return isNonMarc21Tag;
    }

    private static Map<String, Object> controlPositionToJson(ControlfieldPositionDefinition subfield) {
        LinkedHashMap<String, String> codeMap;
        LinkedHashMap codes;
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("position", subfield.formatPositon());
        values.put("label", subfield.getLabel());
        values.put("url", subfield.getDescriptionUrl());
        if (subfield.getCodes() != null) {
            codes = new LinkedHashMap();
            for (Code code : subfield.getCodes()) {
                codeMap = new LinkedHashMap<String, String>();
                codeMap.put("label", code.getLabel());
                codes.put(code.getCode(), codeMap);
            }
            values.put("codes", codes);
        }
        if (subfield.getHistoricalCodes() != null) {
            codes = new LinkedHashMap();
            for (Code code : subfield.getHistoricalCodes()) {
                codeMap = new LinkedHashMap();
                codeMap.put("label", code.getLabel());
                codes.put(code.getCode(), codeMap);
            }
            values.put("historical-codes", codes);
        }
        return values;
    }

    private void dataFieldToJson(Map fields, DataFieldDefinition tag) {
        DataFieldKeyGenerator keyGenerator = new DataFieldKeyGenerator(tag, this.parameters.getSolrFieldType());
        LinkedHashMap<String, Object> tagMap = new LinkedHashMap<String, Object>();
        tagMap.put("tag", tag.getTag());
        tagMap.put("label", tag.getLabel());
        tagMap.put("url", tag.getDescriptionUrl());
        tagMap.put("repeatable", this.resolveCardinality(tag.getCardinality()));
        if (this.exportSelfDescriptiveCodes) {
            tagMap.put("solr", keyGenerator.getIndexTag());
        }
        if (this.parameters.doExportFrbrFunctions()) {
            this.extractFunctions(tagMap, tag.getFrbrFunctions());
        }
        if (this.parameters.doExportCompilanceLevel()) {
            this.extractCompilanceLevel(tagMap, tag.getNationalCompilanceLevel(), tag.getMinimalCompilanceLevel());
        }
        tagMap.put("indicator1", MappingToJson.indicatorToJson(tag.getInd1()));
        tagMap.put("indicator2", MappingToJson.indicatorToJson(tag.getInd2()));
        LinkedHashMap<String, Map<String, Object>> subfields = new LinkedHashMap<String, Map<String, Object>>();
        for (SubfieldDefinition subfield : tag.getSubfields()) {
            subfields.put(subfield.getCode(), this.subfieldToJson(subfield, keyGenerator));
        }
        tagMap.put("subfields", subfields);
        if (tag.getHistoricalSubfields() != null) {
            subfields = new LinkedHashMap();
            for (Code code : tag.getHistoricalSubfields()) {
                LinkedHashMap<String, String> labelMap = new LinkedHashMap<String, String>();
                labelMap.put("label", code.getLabel());
                subfields.put(code.getCode(), labelMap);
            }
            tagMap.put("historical-subfields", subfields);
        }
        fields.put(tag.getTag(), tagMap);
    }

    private void extractFunctions(Map<String, Object> tagMap, List<FRBRFunction> functions) {
        if (functions != null && functions.size() > 0) {
            ArrayList<String> paths = new ArrayList<String>();
            for (FRBRFunction function : functions) {
                paths.add(function.getPath());
            }
            tagMap.put("frbr-functions", paths);
        }
    }

    private Map<String, Object> subfieldToJson(SubfieldDefinition subfield, DataFieldKeyGenerator keyGenerator) {
        LinkedHashMap<String, Object> codeMap = new LinkedHashMap<String, Object>();
        codeMap.put("label", subfield.getLabel());
        codeMap.put("repeatable", this.resolveCardinality(subfield.getCardinality()));
        if (this.exportSelfDescriptiveCodes) {
            codeMap.put("solr", keyGenerator.forSubfield(subfield));
        }
        if (subfield.getCodeList() != null && !subfield.getCodeList().getCodes().isEmpty()) {
            CodeList codeList = subfield.getCodeList();
            LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>();
            meta.put("name", codeList.getName());
            meta.put("url", codeList.getUrl());
            if (this.exportSubfieldCodes && !codeList.getName().equals("MARC Organization Codes")) {
                LinkedHashMap codes = new LinkedHashMap();
                for (Code code : subfield.getCodeList().getCodes()) {
                    LinkedHashMap<String, String> codeListMap = new LinkedHashMap<String, String>();
                    codeListMap.put("label", code.getLabel());
                    codes.put(code.getCode(), codeListMap);
                }
                meta.put("codes", codes);
            }
            codeMap.put("codelist", meta);
        }
        if (this.parameters.doExportFrbrFunctions()) {
            this.extractFunctions(codeMap, subfield.getFrbrFunctions());
        }
        if (this.parameters.doExportCompilanceLevel()) {
            this.extractCompilanceLevel(codeMap, subfield.getNationalCompilanceLevel(), subfield.getMinimalCompilanceLevel());
        }
        return codeMap;
    }

    private void extractCompilanceLevel(Map<String, Object> codeMap, CompilanceLevel nationalCompilanceLevel, CompilanceLevel minimalCompilanceLevel) {
        LinkedHashMap<String, String> levels = new LinkedHashMap<String, String>();
        if (nationalCompilanceLevel != null) {
            levels.put("national", nationalCompilanceLevel.getLabel());
        }
        if (minimalCompilanceLevel != null) {
            levels.put("minimal", minimalCompilanceLevel.getLabel());
        }
        if (levels.size() > 0) {
            codeMap.put("compilance-level", levels);
        }
    }

    private static Map<String, Object> indicatorToJson(Indicator indicator) {
        LinkedHashMap<String, String> map;
        if (!indicator.exists()) {
            return null;
        }
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        value.put("label", indicator.getLabel());
        LinkedHashMap codes = new LinkedHashMap();
        for (Code code : indicator.getCodes()) {
            map = new LinkedHashMap<String, String>();
            map.put("label", code.getLabel());
            codes.put(code.getCode(), map);
        }
        value.put("codes", codes);
        if (indicator.getHistoricalCodes() != null) {
            codes = new LinkedHashMap();
            for (Code code : indicator.getHistoricalCodes()) {
                map = new LinkedHashMap();
                map.put("label", code.getLabel());
                codes.put(code.getCode(), map);
            }
            value.put("historical-codes", codes);
        }
        return value;
    }

    private boolean resolveCardinality(Cardinality cardinality) {
        return cardinality.getCode().equals("R");
    }

    public static void main(String[] args) throws ParseException {
        MappingToJson mapping = new MappingToJson(args);
        mapping.build();
        System.out.println(mapping.toJson());
    }
}

