/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import org.apache.commons.cli.ParseException;

public class ShelfReadyCompletenessParameters
extends CommonParameters {
    public static final String DEFAULT_FILE_NAME = "shelf-ready-completeness.csv";
    private int limit = -1;
    private int offset = -1;
    private String fileName = "shelf-ready-completeness.csv";
    private boolean useStandardOutput = false;
    private boolean isOptionSet = false;

    @Override
    protected void setOptions() {
        if (!this.isOptionSet) {
            super.setOptions();
            this.options.addOption("l", "limit", true, "limit the number of records to process");
            this.options.addOption("o", "offset", true, "the first record to process");
            this.options.addOption("f", "fileName", true, String.format("the report file name (default is %s)", DEFAULT_FILE_NAME));
            this.isOptionSet = true;
        }
    }

    public ShelfReadyCompletenessParameters(String[] arguments) throws ParseException {
        super(arguments);
        if (this.cmd.hasOption("fileName")) {
            this.fileName = this.cmd.getOptionValue("fileName");
        }
        if (this.fileName.equals("stdout")) {
            this.useStandardOutput = true;
        }
        if (this.cmd.hasOption("limit")) {
            this.limit = Integer.parseInt(this.cmd.getOptionValue("limit"));
        }
        if (this.cmd.hasOption("offset")) {
            this.offset = Integer.parseInt(this.cmd.getOptionValue("offset"));
        }
        if (this.offset > -1 && this.limit > -1) {
            this.limit += this.offset;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public boolean useStandardOutput() {
        return this.useStandardOutput;
    }

    @Override
    public String formatParameters() {
        String text = super.formatParameters();
        text = text + String.format("fileName: %s%n", this.fileName);
        text = text + String.format("useStandardOutput: %s%n", this.useStandardOutput);
        text = text + String.format("limit: %s%n", this.limit);
        text = text + String.format("offset: %s%n", this.offset);
        return text;
    }
}

