/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.utils.marcspec.legacy.MarcSpec;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;

public class FormatterParameters
extends CommonParameters {
    private String format = null;
    private int countNr = -1;
    private String search = null;
    private String path = null;
    private String query = null;
    private List<MarcSpec> selector = null;
    private boolean withId = false;
    private String separator = "\t";
    private boolean isOptionSet = false;

    @Override
    protected void setOptions() {
        if (!this.isOptionSet) {
            super.setOptions();
            this.options.addOption("f", "format", true, "specify a format");
            this.options.addOption("c", "countNr", true, "count number of the record (e.g. 1 means the first record)");
            this.options.addOption("s", "search", true, "search string ([path]=[value])");
            this.options.addOption("l", "selector", true, "selectors");
            this.options.addOption("w", "withId", false, "the generated CSV should contain record ID as first field");
            this.options.addOption("p", "separator", true, "separator between the parts (default: TAB)");
            this.isOptionSet = true;
        }
    }

    public FormatterParameters(String[] arguments) throws ParseException {
        super(arguments);
        if (this.cmd.hasOption("format")) {
            this.format = this.cmd.getOptionValue("format");
        }
        if (this.cmd.hasOption("countNr")) {
            this.countNr = Integer.parseInt(this.cmd.getOptionValue("countNr"));
        }
        if (this.cmd.hasOption("search")) {
            this.search = this.cmd.getOptionValue("search");
            String[] parts = this.search.split("=", 2);
            this.path = parts[0];
            this.query = parts[1];
        }
        if (this.cmd.hasOption("selector")) {
            String rawSelector = this.cmd.getOptionValue("selector");
            String[] rawSelectors = rawSelector.split(";");
            this.selector = new ArrayList<MarcSpec>();
            for (String _rawSelector : rawSelectors) {
                this.selector.add(new MarcSpec(_rawSelector));
            }
        }
        this.withId = this.cmd.hasOption("withId");
        if (this.cmd.hasOption("separator")) {
            this.separator = this.cmd.getOptionValue("separator");
        }
    }

    public String getFormat() {
        return this.format;
    }

    public int getCountNr() {
        return this.countNr;
    }

    public String getSearch() {
        return this.search;
    }

    public boolean hasSearch() {
        return StringUtils.isNotBlank((CharSequence)this.path) && StringUtils.isNotBlank((CharSequence)this.query);
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public List<MarcSpec> getSelector() {
        return this.selector;
    }

    public boolean hasSelector() {
        return this.selector != null && !this.selector.isEmpty();
    }

    public boolean withId() {
        return this.withId;
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public String formatParameters() {
        String text = super.formatParameters();
        text = text + String.format("format: %s%n", this.format);
        text = text + String.format("countNr: %s%n", this.countNr);
        text = text + String.format("search: %s%n", this.search);
        text = text + String.format("withId: %s%n", this.withId);
        text = text + String.format("separator: %s%n", this.separator);
        return text;
    }
}

