/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.cli.parameters.ValidatorParameters;
import de.gwdg.metadataqa.marc.cli.processor.MarcFileProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorCategory;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormat;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormatter;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class Validator
implements MarcFileProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(Validator.class.getCanonicalName());
    private Options options;
    private ValidatorParameters parameters;
    private Map<Integer, Integer> totalRecordCounter = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> totalInstanceCounter = new HashMap<Integer, Integer>();
    private Map<ValidationErrorCategory, Integer> categoryRecordCounter = new HashMap<ValidationErrorCategory, Integer>();
    private Map<ValidationErrorCategory, Integer> categoryInstanceCounter = new HashMap<ValidationErrorCategory, Integer>();
    private Map<ValidationErrorType, Integer> typeRecordCounter = new HashMap<ValidationErrorType, Integer>();
    private Map<ValidationErrorType, Integer> typeInstanceCounter = new HashMap<ValidationErrorType, Integer>();
    private Map<ValidationError, Integer> instanceBasedErrorCounter = new HashMap<ValidationError, Integer>();
    private Map<Integer, Integer> recordBasedErrorCounter = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> hashedIndex = new HashMap<Integer, Integer>();
    private Map<Integer, Set<String>> errorCollector = new TreeMap<Integer, Set<String>>();
    private Map<String, Set<String>> ISBNCollector = new TreeMap<String, Set<String>>();
    private Map<String, Set<String>> ISSNCollector = new TreeMap<String, Set<String>>();
    private File detailsFile = null;
    private File summaryFile = null;
    private File collectorFile = null;
    private boolean doPrintInProcessRecord = true;
    private Path currentFile;
    private boolean readyToProcess;
    private int counter;
    private char separator;
    private boolean hasSeparator = false;
    private int vErrorId = 1;

    public Validator(String[] args) throws ParseException {
        this.parameters = new ValidatorParameters(args);
        this.options = this.parameters.getOptions();
        this.readyToProcess = true;
        this.counter = 0;
    }

    public static void main(String[] args) {
        Validator processor = null;
        try {
            processor = new Validator(args);
        }
        catch (ParseException e) {
            System.err.println("ERROR. " + e.getLocalizedMessage());
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        iterator.start();
    }

    @Override
    public void printHelp(Options opions) {
        HelpFormatter formatter = new HelpFormatter();
        String message = String.format("java -cp metadata-qa-marc.jar %s [options] [file]", this.getClass().getCanonicalName());
        formatter.printHelp(message, this.options);
    }

    @Override
    public ValidatorParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void beforeIteration() {
        String header;
        logger.info(this.parameters.formatParameters());
        if (!this.parameters.useStandardOutput()) {
            this.detailsFile = this.prepareReportFile(this.parameters.getOutputDir(), this.parameters.getDetailsFileName());
            logger.info("details output: " + this.detailsFile.getPath());
            if (this.parameters.getSummaryFileName() != null) {
                this.summaryFile = this.prepareReportFile(this.parameters.getOutputDir(), this.parameters.getSummaryFileName());
                logger.info("summary output: " + this.summaryFile.getPath());
                this.collectorFile = this.prepareReportFile(this.parameters.getOutputDir(), "issue-collector.csv");
                header = ValidationErrorFormatter.formatHeaderForCollector(this.parameters.getFormat());
                this.print(this.collectorFile, header + "\n");
            } else if (this.parameters.doSummary()) {
                this.summaryFile = this.detailsFile;
            }
        }
        if (this.parameters.doDetails()) {
            header = ValidationErrorFormatter.formatHeaderForDetails(this.parameters.getFormat());
            this.print(this.detailsFile, header + "\n");
        }
    }

    private File prepareReportFile(String outputDir, String fileName) {
        File reportFile = new File(outputDir, fileName);
        if (reportFile.exists()) {
            reportFile.delete();
        }
        return reportFile;
    }

    @Override
    public void fileOpened(Path currentFile) {
        this.currentFile = currentFile;
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(MarcRecord marcRecord, int i) {
        if (marcRecord.getId() == null) {
            logger.severe("No record number at " + i);
        }
        if (i % 100000 == 0) {
            logger.info("Number of error types so far: " + this.instanceBasedErrorCounter.size());
        }
        if (this.parameters.getIgnorableRecords().isIgnorable(marcRecord)) {
            logger.info("skip " + marcRecord.getId() + " (ignorable record)");
            return;
        }
        boolean isValid = marcRecord.validate(this.parameters.getMarcVersion(), this.parameters.doSummary(), this.parameters.getIgnorableFields());
        if (!isValid && this.doPrintInProcessRecord) {
            if (this.parameters.doSummary()) {
                List<ValidationError> errors = marcRecord.getValidationErrors();
                ArrayList allButInvalidFieldErrors = new ArrayList();
                HashSet<Integer> uniqueErrors = new HashSet<Integer>();
                HashSet<ValidationErrorType> uniqueTypes = new HashSet<ValidationErrorType>();
                HashSet<ValidationErrorCategory> uniqueCategories = new HashSet<ValidationErrorCategory>();
                for (ValidationError validationError : errors) {
                    if (!this.instanceBasedErrorCounter.containsKey(validationError)) {
                        validationError.setId(this.vErrorId++);
                        this.hashedIndex.put(validationError.hashCode(), validationError.getId());
                    } else {
                        validationError.setId(this.hashedIndex.get(validationError.hashCode()));
                    }
                    if (!validationError.getType().equals((Object)ValidationErrorType.FIELD_UNDEFINED)) {
                        Utils.count(2, this.totalInstanceCounter);
                        allButInvalidFieldErrors.add(validationError);
                    }
                    Utils.count(validationError, this.instanceBasedErrorCounter);
                    Utils.count(validationError.getType(), this.typeInstanceCounter);
                    Utils.count(validationError.getType().getCategory(), this.categoryInstanceCounter);
                    Utils.count(1, this.totalInstanceCounter);
                    this.updateErrorCollector(marcRecord.getId(true), validationError.getId());
                    uniqueErrors.add(validationError.getId());
                    uniqueTypes.add(validationError.getType());
                    uniqueCategories.add(validationError.getType().getCategory());
                }
                for (Integer n : uniqueErrors) {
                    Utils.count(n, this.recordBasedErrorCounter);
                }
                for (ValidationErrorType validationErrorType : uniqueTypes) {
                    Utils.count(validationErrorType, this.typeRecordCounter);
                }
                for (ValidationErrorCategory validationErrorCategory : uniqueCategories) {
                    Utils.count(validationErrorCategory, this.categoryRecordCounter);
                }
                Utils.count(1, this.totalRecordCounter);
                if (!allButInvalidFieldErrors.isEmpty()) {
                    Utils.count(2, this.totalRecordCounter);
                }
            }
            if (this.parameters.doDetails()) {
                if (this.parameters.doSummary()) {
                    HashMap<Integer, Integer> errorIds = new HashMap<Integer, Integer>();
                    for (ValidationError error : marcRecord.getValidationErrors()) {
                        if (error.getId() == null) {
                            error.setId(this.hashedIndex.get(error.hashCode()));
                        }
                        Utils.count(error.getId(), errorIds);
                    }
                    String message = ValidationErrorFormatter.formatSimple(marcRecord.getId(this.parameters.getTrimId()), this.parameters.getFormat(), errorIds);
                    this.print(this.detailsFile, message);
                } else {
                    String message = ValidationErrorFormatter.format(marcRecord.getValidationErrors(), this.parameters.getFormat(), this.parameters.getTrimId());
                    this.print(this.detailsFile, message);
                }
            }
        } else if (this.parameters.doSummary()) {
            Utils.count(0, this.totalRecordCounter);
        }
        ++this.counter;
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        logger.info("printCounter");
        this.printCounter(numberOfprocessedRecords);
        char separator = this.getSeparator();
        if (this.parameters.doSummary()) {
            logger.info("printSummary");
            this.printSummary(separator);
            logger.info("printCategoryCounts");
            this.printCategoryCounts();
            logger.info("printTypeCounts");
            this.printTypeCounts();
            logger.info("printTotalCounts");
            this.printTotalCounts();
            logger.info("printCollector");
            this.printCollector();
        }
        logger.info("all printing is DONE");
    }

    private void printCounter(int numberOfprocessedRecords) {
        File countFile = this.prepareReportFile(this.parameters.getOutputDir(), "count.csv");
        if (this.parameters.getIgnorableRecords().isEmpty()) {
            this.printToFile(countFile, "total\n");
            this.printToFile(countFile, String.valueOf(numberOfprocessedRecords) + "\n");
        } else {
            this.printToFile(countFile, StringUtils.join(Arrays.asList("total", "processed"), (String)",") + "\n");
            this.printToFile(countFile, StringUtils.join(Arrays.asList(numberOfprocessedRecords, this.counter), (String)",") + "\n");
        }
    }

    private void printCollector() {
        for (Map.Entry<Integer, Set<String>> entry : this.errorCollector.entrySet()) {
            this.printCollectorEntry(entry.getKey(), entry.getValue());
        }
    }

    private void printSummary(char separator) {
        String header = ValidationErrorFormatter.formatHeaderForSummary(this.parameters.getFormat());
        this.print(this.summaryFile, header + "\n");
        this.instanceBasedErrorCounter.entrySet().stream().sorted((a, b) -> {
            Integer typeIdB;
            Integer typeIdA = ((ValidationError)a.getKey()).getType().getId();
            int result = typeIdA.compareTo(typeIdB = Integer.valueOf(((ValidationError)b.getKey()).getType().getId()));
            if (result == 0) {
                Integer recordCountA = (int)this.recordBasedErrorCounter.get(((ValidationError)a.getKey()).getId());
                Integer recordCountB = (int)this.recordBasedErrorCounter.get(((ValidationError)b.getKey()).getId());
                result = recordCountB.compareTo(recordCountA);
            }
            return result;
        }).forEach(entry -> {
            ValidationError error = (ValidationError)entry.getKey();
            int instanceCount = (Integer)entry.getValue();
            String formattedOutput = ValidationErrorFormatter.formatForSummary(error, this.parameters.getFormat());
            this.print(this.summaryFile, Utils.createRow(Character.valueOf(separator), error.getId(), formattedOutput, instanceCount, this.recordBasedErrorCounter.get(error.getId())));
        });
    }

    private void printTypeCounts() {
        Path path = Paths.get(this.parameters.getOutputDir(), "issue-by-type.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow("id", "categoryId", "category", "type", "instances", "records"));
            this.typeRecordCounter.entrySet().stream().sorted((a, b) -> Integer.valueOf(((ValidationErrorType)((Object)((Object)a.getKey()))).getId()).compareTo(((ValidationErrorType)((Object)((Object)b.getKey()))).getId())).forEach(entry -> {
                ValidationErrorType type = (ValidationErrorType)((Object)((Object)entry.getKey()));
                int records = (Integer)entry.getValue();
                int instances = this.typeInstanceCounter.get(entry.getKey());
                try {
                    writer.write(Utils.createRow(type.getId(), type.getCategory().getId(), type.getCategory().getName(), Utils.quote(type.getMessage()), instances, records));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printTotalCounts() {
        Path path = Paths.get(this.parameters.getOutputDir(), "issue-total.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow("type", "instances", "records"));
            this.totalRecordCounter.entrySet().stream().forEach(entry -> {
                int records = (Integer)entry.getValue();
                int instances = this.totalInstanceCounter.getOrDefault(entry.getKey(), 0);
                try {
                    writer.write(Utils.createRow(entry.getKey(), instances, records));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printCategoryCounts() {
        Path path = Paths.get(this.parameters.getOutputDir(), "issue-by-category.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow("id", "category", "instances", "records"));
            this.categoryRecordCounter.entrySet().stream().sorted((a, b) -> Integer.valueOf(((ValidationErrorCategory)((Object)((Object)a.getKey()))).getId()).compareTo(((ValidationErrorCategory)((Object)((Object)b.getKey()))).getId())).forEach(entry -> {
                ValidationErrorCategory category = (ValidationErrorCategory)((Object)((Object)entry.getKey()));
                int records = (Integer)entry.getValue();
                int instances = this.categoryInstanceCounter.getOrDefault(entry.getKey(), -1);
                try {
                    writer.write(Utils.createRow(category.getId(), category.getName(), instances, records));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private char getSeparator() {
        if (!this.hasSeparator) {
            this.separator = (char)(this.parameters.getFormat().equals((Object)ValidationErrorFormat.TAB_SEPARATED) ? 9 : 44);
        }
        return this.separator;
    }

    private void printCollectorEntry(Integer errorId, Set<String> recordIds) {
        this.print(this.collectorFile, String.valueOf(errorId) + this.separator);
        boolean isFirst = true;
        for (String recordId : recordIds) {
            this.print(this.collectorFile, (isFirst ? "" : ";") + recordId);
            if (!isFirst) continue;
            isFirst = false;
        }
        this.print(this.collectorFile, "\n");
    }

    private void print(File file, String message) {
        if (this.parameters.useStandardOutput()) {
            System.out.print(message);
        } else {
            this.printToFile(file, message);
        }
    }

    private void printToFile(File file, String message) {
        try {
            FileUtils.writeStringToFile((File)file, (String)message, (boolean)true);
        }
        catch (IOException e) {
            if (this.parameters.doLog()) {
                logger.severe(e.toString());
            }
            e.printStackTrace();
        }
    }

    private void updateErrorCollector(String recordId, int errorId) {
        if (!this.errorCollector.containsKey(errorId)) {
            this.errorCollector.put(errorId, new HashSet());
        } else if (this.parameters.doEmptyLargeCollectors() && this.errorCollector.get(errorId).size() >= 1000) {
            this.printCollectorEntry(errorId, this.errorCollector.get(errorId));
            this.errorCollector.put(errorId, new HashSet());
        }
        this.errorCollector.get(errorId).add(recordId);
    }

    public boolean doPrintInProcessRecord() {
        return this.doPrintInProcessRecord;
    }

    public void setDoPrintInProcessRecord(boolean doPrintInProcessRecord) {
        this.doPrintInProcessRecord = doPrintInProcessRecord;
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }

    private class Counter {
        int id;
        int count;

        public Counter(int count, int id) {
            this.count = count;
            this.id = id;
        }
    }
}

