/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.cli.NetworkAnalysis;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class PairGenerator {
    private static final Logger logger = Logger.getLogger(NetworkAnalysis.class.getCanonicalName());
    private String outputDir;
    private final int groupLimit;
    private boolean asBase36 = false;
    private BufferedWriter pairWriter;
    private BufferedWriter nodeWriter;

    public PairGenerator(String outputDir, int groupLimit, boolean asBase36) {
        this.asBase36 = asBase36;
        this.outputDir = outputDir;
        this.groupLimit = groupLimit;
    }

    protected void generatePairs() {
        logger.info("pairIds");
        this.createPairs("");
        Path inputPath = Paths.get(this.outputDir, "network-by-concepts-tags.csv");
        try (Stream<String> stream = Files.lines(Paths.get(inputPath.toString(), new String[0]));){
            stream.forEach(line -> {
                String[] parts = line.split(",");
                if (!parts[0].equals("tag")) {
                    logger.info(parts[0]);
                    this.createPairs(parts[0]);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createPairs(String tag) {
        if (!tag.equals("")) {
            tag = "-" + tag;
        }
        this.initializePairWriter("network-pairs" + tag + ".csv");
        this.initializeNodeWriter("network-nodes" + tag + ".csv");
        this.processConcepts("network-by-concepts" + tag + ".csv");
        try {
            this.pairWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.nodeWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializePairWriter(String fileName) {
        Path outputPath = Paths.get(this.outputDir, fileName);
        try {
            this.pairWriter = Files.newBufferedWriter(outputPath, new OpenOption[0]);
            if (this.asBase36) {
                this.pairWriter.write(Utils.createRow("id1", "id2"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializeNodeWriter(String fileName) {
        Path nodePath = Paths.get(this.outputDir, fileName);
        try {
            this.nodeWriter = Files.newBufferedWriter(nodePath, new OpenOption[0]);
            if (this.asBase36) {
                this.nodeWriter.write(Utils.createRow("id1", "id2"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processConcepts(String fileName) {
        HashMap nodeTrack = new HashMap();
        AtomicInteger lineNr = new AtomicInteger();
        Path inputPath = Paths.get(this.outputDir, fileName);
        try (Stream<String> stream = Files.lines(Paths.get(inputPath.toString(), new String[0]));){
            stream.forEach(line -> {
                String[] parts;
                String[] ids;
                lineNr.getAndIncrement();
                if (lineNr.get() % 100 == 0) {
                    logger.info("" + lineNr.get());
                }
                if ((ids = (parts = line.split(","))[2].split(";")).length > 1) {
                    if (ids.length > this.groupLimit) {
                        logger.info(String.format("%d is greater than %d. The array will will truncated.", ids.length, this.groupLimit));
                        ids = Arrays.copyOfRange(ids, 0, this.groupLimit);
                    }
                    Object[] encoded = this.asBase36 ? this.stringToBase36(ids) : this.stringToInteger(ids);
                    List<String> pairs = this.makePairs(encoded);
                    try {
                        for (String pair : pairs) {
                            this.pairWriter.write(pair);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    for (Object id : encoded) {
                        try {
                            if (nodeTrack.containsKey(id)) continue;
                            this.nodeWriter.write(Utils.createRow(id, id));
                            nodeTrack.put(id, true);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.pairWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Object[] stringToBase36(String[] ids) {
        Object[] encoded = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            encoded[i] = Utils.base36_encode(ids[i]);
        }
        return encoded;
    }

    private Object[] stringToInteger(String[] ids) {
        Object[] encoded = new Integer[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            encoded[i] = Utils.parseId(ids[i]);
        }
        return encoded;
    }

    private List<String> makePairs(Object[] elements) {
        ArrayList<String> pairs = new ArrayList<String>(elements.length);
        int len = elements.length;
        for (int i = 0; i < len - 1; ++i) {
            for (int j = i + 1; j < len; ++j) {
                int b;
                if (this.asBase36) {
                    String a = (String)elements[i];
                    String b2 = (String)elements[j];
                    if (a.equals(b2)) continue;
                    pairs.add(Utils.createRow(elements[i], elements[j]));
                    continue;
                }
                int a = (Integer)elements[i];
                if (a == (b = ((Integer)elements[j]).intValue())) continue;
                pairs.add(Utils.createRowWithSep(' ', a, b));
            }
        }
        return pairs;
    }
}

