/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.AuthorithyAnalyzer;
import de.gwdg.metadataqa.marc.analysis.AuthorityCategory;
import de.gwdg.metadataqa.marc.analysis.AuthorityStatistics;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.ValidatorParameters;
import de.gwdg.metadataqa.marc.cli.processor.MarcFileProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.cli.utils.Schema;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class AuthorityAnalysis
implements MarcFileProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(AuthorityAnalysis.class.getCanonicalName());
    private final Options options;
    private CommonParameters parameters;
    private Map<Integer, Integer> histogram = new HashMap<Integer, Integer>();
    private Map<Integer, String> frequencyExamples = new HashMap<Integer, String>();
    private Map<Boolean, Integer> hasClassifications = new HashMap<Boolean, Integer>();
    private boolean readyToProcess;
    private static char separator = (char)44;
    AuthorityStatistics statistics = new AuthorityStatistics();

    public AuthorityAnalysis(String[] args) throws ParseException {
        this.parameters = new ValidatorParameters(args);
        this.options = this.parameters.getOptions();
        this.readyToProcess = true;
    }

    public static void main(String[] args) {
        AuthorityAnalysis processor = null;
        try {
            processor = new AuthorityAnalysis(args);
        }
        catch (ParseException e) {
            System.err.println(AuthorityAnalysis.createRow("ERROR. ", e.getLocalizedMessage()));
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        iterator.start();
    }

    @Override
    public CommonParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(MarcRecord marcRecord, int recordNumber) throws IOException {
        if (this.parameters.getIgnorableRecords().isIgnorable(marcRecord)) {
            return;
        }
        AuthorithyAnalyzer analyzer = new AuthorithyAnalyzer(marcRecord, this.statistics);
        int count = analyzer.process();
        Utils.count(count > 0, this.hasClassifications);
        Utils.count(count, this.histogram);
        if (!this.frequencyExamples.containsKey(count)) {
            this.frequencyExamples.put(count, marcRecord.getId(true));
        }
    }

    @Override
    public void beforeIteration() {
    }

    @Override
    public void fileOpened(Path path) {
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        this.printAuthoritiesByCategories();
        this.printAuthoritiesBySchema();
        this.printAuthoritiesByRecords();
        this.printAuthoritiesHistogram();
        this.printFrequencyExamples();
        this.printAuthoritiesSubfieldsStatistics();
    }

    private void printAuthoritiesByCategories() {
        Path path = Paths.get(this.parameters.getOutputDir(), "authorities-by-categories.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(AuthorityAnalysis.createRow("category", "recordcount", "instancecount"));
            this.statistics.getRecordsPerCategories().entrySet().stream().forEach(entry -> {
                AuthorityCategory category = (AuthorityCategory)((Object)((Object)entry.getKey()));
                int recordCount = (Integer)entry.getValue();
                int instanceCount = this.statistics.getInstancesPerCategories().get(category);
                try {
                    writer.write(AuthorityAnalysis.createRow(Utils.quote(category.getLabel()), recordCount, instanceCount));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    System.err.println((Object)category);
                }
                catch (NullPointerException ex) {
                    ex.printStackTrace();
                    System.err.println((Object)category);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printAuthoritiesBySchema() {
        Path path = Paths.get(this.parameters.getOutputDir(), "authorities-by-schema.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(AuthorityAnalysis.createRow("id", "field", "location", "scheme", "abbreviation", "abbreviation4solr", "recordcount", "instancecount"));
            this.statistics.getInstances().entrySet().stream().sorted((e1, e2) -> {
                int i = ((Schema)e1.getKey()).getField().compareTo(((Schema)e2.getKey()).getField());
                if (i != 0) {
                    return i;
                }
                i = ((Schema)e1.getKey()).getLocation().compareTo(((Schema)e2.getKey()).getLocation());
                if (i != i) {
                    return i;
                }
                return ((Integer)e2.getValue()).compareTo((Integer)e1.getValue());
            }).forEach(entry -> this.printSingleClassificationBySchema(writer, (Map.Entry<Schema, Integer>)entry));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printSingleClassificationBySchema(BufferedWriter writer, Map.Entry<Schema, Integer> entry) {
        Schema schema = entry.getKey();
        int instanceCount = entry.getValue();
        int recordCount = this.statistics.getRecords().get(schema);
        try {
            writer.write(AuthorityAnalysis.createRow(schema.getId(), schema.getField(), schema.getLocation(), '\"' + schema.getSchema().replace("\"", "\\\"") + '\"', schema.getAbbreviation(), Utils.solarize(schema.getAbbreviation()), recordCount, instanceCount));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.err.println(schema);
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
            System.err.println(schema);
        }
    }

    private void printAuthoritiesByRecords() {
        Path path = Paths.get(this.parameters.getOutputDir(), "authorities-by-records.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(AuthorityAnalysis.createRow("records-with-authorities", "count"));
            this.hasClassifications.entrySet().stream().sorted((e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue())).forEach(e -> {
                try {
                    writer.write(AuthorityAnalysis.createRow(((Boolean)e.getKey()).toString(), e.getValue()));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            });
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
    }

    private void printAuthoritiesHistogram() {
        Path path = Paths.get(this.parameters.getOutputDir(), "authorities-histogram.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(AuthorityAnalysis.createRow("count", "frequency"));
            this.histogram.entrySet().stream().sorted((e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey())).forEach(entry -> {
                try {
                    writer.write(AuthorityAnalysis.createRow(entry.getKey(), entry.getValue()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printFrequencyExamples() {
        Path path = Paths.get(this.parameters.getOutputDir(), "authorities-frequency-examples.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(AuthorityAnalysis.createRow("count", "id"));
            this.frequencyExamples.entrySet().stream().sorted((e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey())).forEach(entry -> {
                try {
                    writer.write(AuthorityAnalysis.createRow(entry.getKey(), entry.getValue()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printAuthoritiesSubfieldsStatistics() {
        Path path = Paths.get(this.parameters.getOutputDir(), "authorities-by-schema-subfields.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            List<String> header = Arrays.asList("id", "subfields", "count");
            writer.write(AuthorityAnalysis.createRow(header));
            this.statistics.getSubfields().entrySet().stream().sorted((e1, e2) -> ((Schema)e1.getKey()).getField().compareTo(((Schema)e2.getKey()).getField())).forEach(schemaEntry -> this.printSingleSchemaSubfieldsStatistics(writer, (Map.Entry<Schema, Map<List<String>, Integer>>)schemaEntry));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printSingleSchemaSubfieldsStatistics(BufferedWriter writer, Map.Entry<Schema, Map<List<String>, Integer>> schemaEntry) {
        Schema schema = schemaEntry.getKey();
        Map<List<String>, Integer> val = schemaEntry.getValue();
        val.entrySet().stream().sorted((count1, count2) -> ((Integer)count2.getValue()).compareTo((Integer)count1.getValue())).forEach(countEntry -> {
            List subfields = (List)countEntry.getKey();
            int count = (Integer)countEntry.getValue();
            try {
                writer.write(AuthorityAnalysis.createRow(schema.getId(), StringUtils.join((Iterable)subfields, (char)';'), count));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        });
    }

    private static String createRow(List<String> fields) {
        return StringUtils.join(fields, (char)separator) + "\n";
    }

    private static String createRow(Object ... fields) {
        return StringUtils.join((Object[])fields, (char)separator) + "\n";
    }

    @Override
    public void printHelp(Options options) {
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }
}

