/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.analysis.ShelfReadyFieldsBooks;
import de.gwdg.metadataqa.marc.utils.marcspec.legacy.MarcSpec;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ShelfReadyAnalysis {
    private static List<String> headers = new LinkedList<String>();

    public static List<Double> getScores(MarcRecord marcRecord) {
        ArrayList<Double> scores = new ArrayList<Double>();
        double total = 0.0;
        for (ShelfReadyFieldsBooks fieldEntry : ShelfReadyFieldsBooks.values()) {
            double score = 0.0;
            double count = fieldEntry.getSelectors().size();
            for (MarcSpec selector : fieldEntry.getSelectors()) {
                List<String> values = marcRecord.select(selector);
                if (values.size() <= 0) continue;
                score += 1.0;
                if (!fieldEntry.isOneOf()) continue;
                break;
            }
            if (fieldEntry.isOneOf()) {
                score = fieldEntry.getScore();
            } else {
                double mean = score / count;
                score = mean * (double)fieldEntry.getScore();
            }
            scores.add(score);
            total += score;
        }
        scores.add(total /= (double)scores.size());
        return scores;
    }

    public static List<String> getHeaders() {
        return headers;
    }

    static {
        for (ShelfReadyFieldsBooks field : ShelfReadyFieldsBooks.values()) {
            headers.add(field.name());
        }
    }
}

