/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import com.jayway.jsonpath.InvalidJsonException;
import de.gwdg.metadataqa.api.calculator.CalculatorFacade;
import de.gwdg.metadataqa.api.calculator.CompletenessCalculator;
import de.gwdg.metadataqa.api.calculator.FieldExtractor;
import de.gwdg.metadataqa.api.calculator.LanguageCalculator;
import de.gwdg.metadataqa.api.calculator.MultilingualitySaturationCalculator;
import de.gwdg.metadataqa.api.calculator.TfIdfCalculator;
import de.gwdg.metadataqa.api.schema.MarcJsonSchema;
import de.gwdg.metadataqa.api.schema.Schema;
import java.util.ArrayList;
import java.util.logging.Logger;

public class MarcJsonCalculatorFacade
extends CalculatorFacade {
    private static final Logger logger = Logger.getLogger(MarcJsonCalculatorFacade.class.getCanonicalName());
    private MarcJsonSchema schema = new MarcJsonSchema();
    protected FieldExtractor fieldExtractor;
    protected Formats format = Formats.OAI_PMH_XML;

    public MarcJsonCalculatorFacade() {
    }

    public MarcJsonCalculatorFacade(boolean enableFieldExistenceMeasurement, boolean enableFieldCardinalityMeasurement, boolean enableCompletenessMeasurement, boolean enableTfIdfMeasurement, boolean enableProblemCatalogMeasurement) {
        super(enableFieldExistenceMeasurement, enableFieldCardinalityMeasurement, enableCompletenessMeasurement, enableTfIdfMeasurement, enableProblemCatalogMeasurement);
    }

    public MarcJsonCalculatorFacade(boolean enableFieldExistenceMeasurement, boolean enableFieldCardinalityMeasurement, boolean enableCompletenessMeasurement, boolean enableTfIdfMeasurement, boolean enableProblemCatalogMeasurement, boolean abbreviate) {
        super(enableFieldExistenceMeasurement, enableFieldCardinalityMeasurement, enableCompletenessMeasurement, enableTfIdfMeasurement, enableProblemCatalogMeasurement);
        this.conditionalConfiguration();
    }

    public void configure() {
        this.calculators = new ArrayList();
        this.fieldExtractor = new FieldExtractor((Schema)this.schema);
        this.calculators.add(this.fieldExtractor);
        if (this.completenessMeasurementEnabled || this.fieldExistenceMeasurementEnabled || this.fieldCardinalityMeasurementEnabled) {
            this.completenessCalculator = new CompletenessCalculator((Schema)this.schema);
            this.completenessCalculator.setCompleteness(this.completenessMeasurementEnabled);
            this.completenessCalculator.setExistence(this.fieldExistenceMeasurementEnabled);
            this.completenessCalculator.setCardinality(this.fieldCardinalityMeasurementEnabled);
            this.completenessCalculator.collectFields(this.completenessCollectFields);
            this.calculators.add(this.completenessCalculator);
        }
        if (this.tfIdfMeasurementEnabled) {
            this.tfidfCalculator = new TfIdfCalculator((Schema)this.schema);
            this.tfidfCalculator.enableTermCollection(this.collectTfIdfTerms);
            this.calculators.add(this.tfidfCalculator);
        }
        if (this.languageMeasurementEnabled) {
            this.languageCalculator = new LanguageCalculator((Schema)this.schema);
            this.calculators.add(this.languageCalculator);
        }
        if (this.multilingualSaturationMeasurementEnabled) {
            this.multilingualSaturationCalculator = new MultilingualitySaturationCalculator((Schema)this.schema);
            if (this.saturationExtendedResult) {
                this.multilingualSaturationCalculator.setResultType(MultilingualitySaturationCalculator.ResultTypes.EXTENDED);
            }
            this.calculators.add(this.multilingualSaturationCalculator);
        }
    }

    public String measure(String jsonRecord) throws InvalidJsonException {
        return this.measureWithGenerics(jsonRecord);
    }

    public Formats getFormat() {
        return this.format;
    }

    public void setFormat(Formats format) {
        this.format = format;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static enum Formats {
        OAI_PMH_XML("xml"),
        FULLBEAN("fullbean");

        private final String name;

        private Formats(String name) {
            this.name = name;
        }
    }
}

