/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import com.jayway.jsonpath.InvalidJsonException;
import de.gwdg.metadataqa.api.counter.FieldCounter;
import de.gwdg.metadataqa.api.interfaces.Calculator;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.pathcache.JsonPathCache;
import de.gwdg.metadataqa.api.model.pathcache.PathCache;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.api.util.CompressionLevel;
import de.gwdg.metadataqa.marc.Control007;
import de.gwdg.metadataqa.marc.Control008;
import de.gwdg.metadataqa.marc.Leader;
import de.gwdg.metadataqa.marc.X035aSystemControlNumber;
import de.gwdg.metadataqa.marc.definition.general.codelist.CodeList;
import de.gwdg.metadataqa.marc.definition.general.codelist.LanguageCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MarcFieldExtractor
implements Calculator,
Serializable {
    public static final String CALCULATOR_NAME = "fieldExtractor";
    private static final Logger logger = Logger.getLogger(MarcFieldExtractor.class.getCanonicalName());
    private static final List<String> authorFields = Arrays.asList("100$a", "110$a", "700$a", "710$a");
    public static final String FIELD_NAME = "recordId";
    private String idPath;
    protected FieldCounter<List<String>> resultMap;
    protected Schema schema;
    private String recordId;
    private Leader leader;
    private Control007 x007;
    private Control008 x008;
    private Map<String, Object> duplumKeyMap;
    private List<String> titleWords;
    private List<String> authorWords;
    private String duplumKeyType;
    private List<String> dateOfPublication;
    private List<String> isbn;
    private String publisherOrDistributorNumber;
    private String abbreviatedNameOfPublisher;
    private String numberOfPart;
    private String nameOfPart;
    private String extent;
    private String musicalPresentationStatement;
    private String volumeDesignation;
    private String relatedParts;
    private List<X035aSystemControlNumber> systemControlNumbers;
    private Map<String, Object> oclcMap;
    private boolean valid;

    public MarcFieldExtractor() {
    }

    public MarcFieldExtractor(Schema schema) {
        this.schema = schema;
        this.setIdPath((String)schema.getExtractableFields().get("001"));
    }

    public MarcFieldExtractor(String idPath) {
        this.idPath = idPath;
    }

    public String getCalculatorName() {
        return CALCULATOR_NAME;
    }

    public void measure(JsonPathCache cache) throws InvalidJsonException {
        this.valid = true;
        this.resultMap = new FieldCounter();
        this.duplumKeyMap = null;
        this.recordId = null;
        this.leader = null;
        this.x007 = null;
        this.x008 = null;
        this.titleWords = null;
        this.authorWords = null;
        this.duplumKeyType = null;
        this.dateOfPublication = null;
        this.isbn = null;
        this.publisherOrDistributorNumber = null;
        this.abbreviatedNameOfPublisher = null;
        this.numberOfPart = null;
        this.nameOfPart = null;
        this.extent = null;
        this.musicalPresentationStatement = null;
        this.volumeDesignation = null;
        this.relatedParts = null;
        this.systemControlNumbers = null;
        this.oclcMap = null;
        this.recordId = ((XmlFieldInstance)cache.get(this.getIdPath()).get(0)).getValue();
        cache.setRecordId(this.recordId);
        this.resultMap.put(FIELD_NAME, Arrays.asList(this.recordId));
        if (this.schema != null) {
            for (String fieldName : this.schema.getExtractableFields().keySet()) {
                if (fieldName.equals(FIELD_NAME)) continue;
                String path = (String)this.schema.getExtractableFields().get(fieldName);
                List instances = cache.get(path);
                ArrayList<String> values = null;
                if (!MarcFieldExtractor.isNull(instances)) {
                    values = new ArrayList<String>();
                    for (XmlFieldInstance instance : instances) {
                        values.add(instance.getValue());
                    }
                    if (fieldName.equals("leader")) {
                        this.leader = new Leader((String)values.get(0));
                    }
                }
                this.resultMap.put(fieldName, values);
            }
        }
        this.processLeader();
        this.process007();
        this.process008();
        this.processType();
        this.processTitleWords();
        this.processAuthorWords();
        this.processDateOfPublication();
        this.processIsbn();
        this.processPublisherOrDistributorNumber();
        this.processAbbreviatedNameOfPublisher();
        this.processNumberOfPart();
        this.processNameOfPart();
        this.processExtent();
        this.processMusicalPresentationStatement();
        this.processVolumeDesignation();
        this.processRelatedParts();
        this.processSystemControlNumbers();
        this.processOclcFields();
        this.createDuplumKeyMap();
    }

    private static boolean isNull(List<XmlFieldInstance> values) {
        return values == null || values.isEmpty() || values.get(0) == null || values.get(0).getValue() == null;
    }

    public String getIdPath() {
        return this.idPath;
    }

    public void setIdPath(String idPath) {
        this.idPath = idPath;
    }

    public void measure(PathCache pathCache) {
    }

    public Map<String, ? extends Object> getResultMap() {
        return this.resultMap.getMap();
    }

    public Map<String, Map<String, ? extends Object>> getLabelledResultMap() {
        LinkedHashMap<String, Map<String, ? extends Object>> labelledResultMap = new LinkedHashMap<String, Map<String, ? extends Object>>();
        labelledResultMap.put(this.getCalculatorName(), this.resultMap.getMap());
        return labelledResultMap;
    }

    public String getCsv(boolean withLabel, CompressionLevel compressionLevel) {
        return this.resultMap.getList(withLabel, CompressionLevel.ZERO);
    }

    public List<String> getHeader() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(FIELD_NAME);
        return headers;
    }

    public void processLeader() {
        if (this.resultMap.has("leader")) {
            this.leader = new Leader((String)((List)this.resultMap.get("leader")).get(0));
        } else {
            logger.severe(String.format("No leader in result map. Nr of existing vars: %s", StringUtils.join(this.resultMap.getMap().keySet(), (String)", ")));
        }
    }

    public void process007() {
        if (this.resultMap.get("007") == null) {
            this.valid = false;
        } else {
            this.x007 = new Control007((String)((List)this.resultMap.get("007")).get(0));
        }
    }

    public void process008() {
        if (this.resultMap.get("008") != null && StringUtils.isNotBlank((CharSequence)((CharSequence)((List)this.resultMap.get("008")).get(0)))) {
            this.x008 = new Control008((String)((List)this.resultMap.get("008")).get(0), this.leader.getType());
        }
    }

    private void processTitleWords() {
        this.titleWords = this.extractWords(StringUtils.join((Iterable)((Iterable)this.resultMap.get("245$a")), (String)" "), 3);
    }

    private void processType() {
        String typeOfRecord = this.leader.getByLabel("Type of record");
        String bibliographicLevel = this.leader.getByLabel("Bibliographic level");
        this.duplumKeyType = typeOfRecord.equals("a") && bibliographicLevel.equals("s") ? "p" : (bibliographicLevel.equals("d") ? "s" : (bibliographicLevel.equals("a") || bibliographicLevel.equals("b") ? "a" : "m"));
    }

    public List<String> extractWords(String text, int length) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)text)) {
            return tokens;
        }
        StringTokenizer st = new StringTokenizer(text);
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        int max = Math.min(length, tokens.size());
        return tokens.subList(0, max);
    }

    public String getRecordId() {
        return this.recordId;
    }

    public Leader getLeader() {
        return this.leader;
    }

    public Control007 getX007() {
        return this.x007;
    }

    public Control008 getX008() {
        return this.x008;
    }

    public List<String> getTitleWords() {
        return this.titleWords;
    }

    public List<String> getAuthorWords() {
        return this.authorWords;
    }

    public String getDuplumKeyType() {
        return this.duplumKeyType;
    }

    public List<String> getDateOfPublication() {
        return this.dateOfPublication;
    }

    public List<String> getIsbn() {
        return this.isbn;
    }

    public String getPublisherOrDistributorNumber() {
        return this.publisherOrDistributorNumber;
    }

    public String getAbbreviatedNameOfPublisher() {
        return this.abbreviatedNameOfPublisher;
    }

    public String getNumberOfPart() {
        return this.numberOfPart;
    }

    public String getNameOfPart() {
        return this.nameOfPart;
    }

    public String getExtent() {
        return this.extent;
    }

    public String getMusicalPresentationStatement() {
        return this.musicalPresentationStatement;
    }

    public String getVolumeDesignation() {
        return this.volumeDesignation;
    }

    public String getRelatedParts() {
        return this.relatedParts;
    }

    private void processAuthorWords() {
        String author = this.extractAuthor();
        this.authorWords = this.extractWords(author, 3);
    }

    private String extractAuthor() {
        String author = null;
        for (String field : authorFields) {
            Object value = this.resultMap.get(field);
            String stringValue = value instanceof List ? StringUtils.join((Iterable)((List)value), (String)" ") : (String)value;
            if (!StringUtils.isNotBlank((CharSequence)stringValue)) continue;
            author = stringValue;
            break;
        }
        return author;
    }

    private void processDateOfPublication() {
        this.dateOfPublication = (List)this.resultMap.get("260$c");
    }

    private void processIsbn() {
        this.isbn = (List)this.resultMap.get("020$a");
    }

    private void processPublisherOrDistributorNumber() {
        this.publisherOrDistributorNumber = this.duplumKeyType.equals("m") ? null : StringUtils.join((Iterable)((Iterable)this.resultMap.get("028$a")), (String)"; ");
    }

    private void processAbbreviatedNameOfPublisher() {
        this.abbreviatedNameOfPublisher = StringUtils.join((Iterable)((Iterable)this.resultMap.get("060$b")), (String)"; ");
    }

    private void processNumberOfPart() {
        this.numberOfPart = StringUtils.join((Iterable)((Iterable)this.resultMap.get("245$n")), (String)"; ");
    }

    private void processNameOfPart() {
        this.nameOfPart = StringUtils.join((Iterable)((Iterable)this.resultMap.get("245$p")), (String)"; ");
    }

    private void processExtent() {
        this.extent = StringUtils.join((Iterable)((Iterable)this.resultMap.get("300$a")), (String)"; ");
    }

    private void processMusicalPresentationStatement() {
        this.musicalPresentationStatement = StringUtils.join((Iterable)((Iterable)this.resultMap.get("254$a")), (String)"; ");
    }

    private void processVolumeDesignation() {
        this.volumeDesignation = StringUtils.join((Iterable)((Iterable)this.resultMap.get("490$v")), (String)"; ");
    }

    private void processRelatedParts() {
        this.relatedParts = StringUtils.join((Iterable)((Iterable)this.resultMap.get("773$g")), (String)"; ");
    }

    private void processOclcFields() {
        this.oclcMap = new LinkedHashMap<String, Object>();
        this.oclcMap.put("oclcLibraryIdentifier", this.resolve((List)this.resultMap.get("029$a"), OrganizationCodes.getInstance()));
        this.oclcMap.put("otherSystemControlNumber", this.resultMap.get("029$b"));
        this.oclcMap.put("catalogingAgency", this.resolve((List)this.resultMap.get("040$a"), OrganizationCodes.getInstance()));
        this.oclcMap.put("languageOfCataloging", this.resolve((List)this.resultMap.get("040$b"), LanguageCodes.getInstance()));
        this.oclcMap.put("transcribingAgency", this.resolve((List)this.resultMap.get("040$c"), OrganizationCodes.getInstance()));
        this.oclcMap.put("modifyingAgency", this.resolve((List)this.resultMap.get("040$d"), OrganizationCodes.getInstance()));
        this.oclcMap.put("topicalTerm", this.resultMap.get("650$a"));
        this.oclcMap.put("manifestId", this.resultMap.get("911$9"));
        this.oclcMap.put("workId", this.resultMap.get("912$9"));
        this.oclcMap.put("placeOfPublication", this.resultMap.get("260$a"));
        this.oclcMap.put("nameOfPublisher", this.resultMap.get("260$b"));
        this.oclcMap.put("sourceOfHeading", this.resultMap.get("650$2"));
        this.oclcMap.put("title", this.resultMap.get("245$a"));
    }

    private Object resolve(List<String> list, CodeList codeService) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<String> resolvedList = new ArrayList<String>();
        for (String code : list) {
            if (codeService.isValid(code)) {
                resolvedList.add(codeService.getCode(code).getLabel());
                continue;
            }
            resolvedList.add(code);
        }
        return resolvedList;
    }

    public Map<String, Object> getDuplumKeyMap() {
        if (this.duplumKeyMap == null) {
            this.createDuplumKeyMap();
        }
        return this.duplumKeyMap;
    }

    public void createDuplumKeyMap() {
        this.duplumKeyMap = new HashMap<String, Object>();
        this.duplumKeyMap.put(FIELD_NAME, this.recordId);
        this.duplumKeyMap.put("titleWords", this.titleWords);
        this.duplumKeyMap.put("authorWords", this.authorWords);
        this.duplumKeyMap.put("duplumKeyType", this.duplumKeyType);
        this.duplumKeyMap.put("dateOfPublication", this.dateOfPublication);
        this.duplumKeyMap.put("isbn", this.isbn);
        this.duplumKeyMap.put("publisherOrDistributorNumber", this.publisherOrDistributorNumber);
        this.duplumKeyMap.put("abbreviatedNameOfPublisher", this.abbreviatedNameOfPublisher);
        this.duplumKeyMap.put("numberOfPart", this.numberOfPart);
        this.duplumKeyMap.put("nameOfPart", this.nameOfPart);
        this.duplumKeyMap.put("extent", this.extent);
        this.duplumKeyMap.put("musicalPresentationStatement", this.musicalPresentationStatement);
        this.duplumKeyMap.put("volumeDesignation", this.volumeDesignation);
        this.duplumKeyMap.put("relatedParts", this.relatedParts);
        this.duplumKeyMap.put("systemControlNumbers", this.systemControlNumbers);
        for (Map.Entry<String, Object> entry : this.oclcMap.entrySet()) {
            this.duplumKeyMap.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    private void processSystemControlNumbers() {
        this.systemControlNumbers = new ArrayList<X035aSystemControlNumber>();
        if (this.resultMap.get("035$a") != null) {
            for (String original : (List)this.resultMap.get("035$a")) {
                this.systemControlNumbers.add(new X035aSystemControlNumber(original));
            }
        }
    }
}

