/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.api.json.JsonBranch;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.pathcache.JsonPathCache;
import de.gwdg.metadataqa.api.schema.MarcJsonSchema;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.marc.Control006;
import de.gwdg.metadataqa.marc.Control007;
import de.gwdg.metadataqa.marc.Control008;
import de.gwdg.metadataqa.marc.DataField;
import de.gwdg.metadataqa.marc.Leader;
import de.gwdg.metadataqa.marc.MarcControlField;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.TagDefinitionLoader;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control001Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control003Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control005Definition;
import de.gwdg.metadataqa.marc.utils.MapToDatafield;
import de.gwdg.metadataqa.marc.utils.alephseq.AlephseqLine;
import de.gwdg.metadataqa.marc.utils.pica.PicaLine;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.minidev.json.JSONArray;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.ControlFieldImpl;
import org.marc4j.marc.impl.DataFieldImpl;
import org.marc4j.marc.impl.LeaderImpl;
import org.marc4j.marc.impl.RecordImpl;
import org.marc4j.marc.impl.SubfieldImpl;

public class MarcFactory {
    private static final Logger logger = Logger.getLogger(MarcFactory.class.getCanonicalName());
    private static final List<String> fixableControlFields = Arrays.asList("006", "007", "008");
    private static Schema schema = new MarcJsonSchema();

    public static MarcRecord create(JsonPathCache cache) {
        return MarcFactory.create(cache, MarcVersion.MARC21);
    }

    public static MarcRecord create(JsonPathCache cache, MarcVersion version) {
        MarcRecord record = new MarcRecord();
        block18: for (JsonBranch branch : schema.getPaths()) {
            if (branch.getParent() != null) continue;
            switch (branch.getLabel()) {
                case "leader": {
                    record.setLeader(new Leader(MarcFactory.extractFirst(cache, branch)));
                    continue block18;
                }
                case "001": {
                    record.setControl001(new MarcControlField(Control001Definition.getInstance(), MarcFactory.extractFirst(cache, branch)));
                    continue block18;
                }
                case "003": {
                    record.setControl003(new MarcControlField(Control003Definition.getInstance(), MarcFactory.extractFirst(cache, branch)));
                    continue block18;
                }
                case "005": {
                    record.setControl005(new MarcControlField(Control005Definition.getInstance(), MarcFactory.extractFirst(cache, branch)));
                    continue block18;
                }
                case "006": {
                    record.setControl006(new Control006(MarcFactory.extractFirst(cache, branch), record.getType()));
                    continue block18;
                }
                case "007": {
                    record.setControl007(new Control007(MarcFactory.extractFirst(cache, branch)));
                    continue block18;
                }
                case "008": {
                    record.setControl008(new Control008(MarcFactory.extractFirst(cache, branch), record.getType()));
                    continue block18;
                }
            }
            JSONArray fieldInstances = (JSONArray)cache.getFragment(branch.getJsonPath());
            for (int fieldInsanceNr = 0; fieldInsanceNr < fieldInstances.size(); ++fieldInsanceNr) {
                Map fieldInstance = (Map)fieldInstances.get(fieldInsanceNr);
                DataField field = MapToDatafield.parse(fieldInstance, version);
                if (field != null) {
                    record.addDataField(field);
                    field.setRecord(record);
                    continue;
                }
                record.addUnhandledTags(branch.getLabel());
            }
        }
        return record;
    }

    public static MarcRecord createFromMarc4j(Record marc4jRecord) {
        return MarcFactory.createFromMarc4j(marc4jRecord, null, MarcVersion.MARC21);
    }

    public static MarcRecord createFromMarc4j(Record marc4jRecord, Leader.Type defaultType) {
        return MarcFactory.createFromMarc4j(marc4jRecord, defaultType, MarcVersion.MARC21);
    }

    public static MarcRecord createFromMarc4j(Record marc4jRecord, MarcVersion marcVersion) {
        return MarcFactory.createFromMarc4j(marc4jRecord, null, marcVersion);
    }

    public static MarcRecord createFromMarc4j(Record marc4jRecord, Leader.Type defaultType, MarcVersion marcVersion) {
        return MarcFactory.createFromMarc4j(marc4jRecord, defaultType, marcVersion, false);
    }

    public static MarcRecord createFromMarc4j(Record marc4jRecord, Leader.Type defaultType, MarcVersion marcVersion, boolean fixAlephseq) {
        MarcRecord record = new MarcRecord();
        record.setLeader(new Leader(marc4jRecord.getLeader().marshal(), defaultType));
        if (record.getType() == null) {
            throw new InvalidParameterException(String.format("Error in '%s': no type has been detected. Leader: '%s'.", marc4jRecord.getControlNumberField(), record.getLeader().getLeaderString()));
        }
        MarcFactory.importMarc4jControlFields(marc4jRecord, record, fixAlephseq);
        MarcFactory.importMarc4jDataFields(marc4jRecord, record, marcVersion);
        return record;
    }

    private static void importMarc4jControlFields(Record marc4jRecord, MarcRecord record, boolean fixAlephseq) {
        for (ControlField controlField : marc4jRecord.getControlFields()) {
            String data = controlField.getData();
            if (fixAlephseq && MarcFactory.isFixable(controlField.getTag())) {
                data = data.replace("^", " ");
            }
            switch (controlField.getTag()) {
                case "001": {
                    record.setControl001(new MarcControlField(Control001Definition.getInstance(), data));
                    break;
                }
                case "003": {
                    record.setControl003(new MarcControlField(Control003Definition.getInstance(), data));
                    break;
                }
                case "005": {
                    record.setControl005(new MarcControlField(Control005Definition.getInstance(), data));
                    break;
                }
                case "006": {
                    record.setControl006(new Control006(data, record.getType()));
                    break;
                }
                case "007": {
                    record.setControl007(new Control007(record, data));
                    break;
                }
                case "008": {
                    record.setControl008(new Control008(data, record.getType()));
                    break;
                }
            }
        }
    }

    private static boolean isFixable(String tag) {
        return fixableControlFields.contains(tag);
    }

    private static void importMarc4jDataFields(Record marc4jRecord, MarcRecord record, MarcVersion marcVersion) {
        for (org.marc4j.marc.DataField dataField : marc4jRecord.getDataFields()) {
            DataFieldDefinition definition = MarcFactory.getDataFieldDefinition(dataField, marcVersion);
            if (definition == null) {
                record.addUnhandledTags(dataField.getTag());
            }
            DataField field = MarcFactory.extractDataField(dataField, definition, marcVersion, record.getControl001().getContent());
            record.addDataField(field);
        }
    }

    public static DataFieldDefinition getDataFieldDefinition(org.marc4j.marc.DataField dataField, MarcVersion marcVersion) {
        return MarcFactory.getDataFieldDefinition(dataField.getTag(), marcVersion);
    }

    public static DataFieldDefinition getDataFieldDefinition(String tag, MarcVersion marcVersion) {
        return TagDefinitionLoader.load(tag, marcVersion);
    }

    private static DataField extractDataField(org.marc4j.marc.DataField dataField, DataFieldDefinition definition, MarcVersion marcVersion, String identifier) {
        DataField field = definition == null ? new DataField(dataField.getTag(), Character.toString(dataField.getIndicator1()), Character.toString(dataField.getIndicator2()), marcVersion) : new DataField(definition, Character.toString(dataField.getIndicator1()), Character.toString(dataField.getIndicator2()));
        for (Subfield subfield : dataField.getSubfields()) {
            String code = Character.toString(subfield.getCode());
            SubfieldDefinition subfieldDefinition = definition == null ? null : definition.getSubfield(code);
            MarcSubfield marcSubfield = null;
            marcSubfield = subfieldDefinition == null ? new MarcSubfield(null, code, subfield.getData()) : new MarcSubfield(subfieldDefinition, code, subfield.getData());
            marcSubfield.setField(field);
            field.getSubfields().add(marcSubfield);
        }
        field.indexSubfields();
        return field;
    }

    private static List<String> extractList(JsonPathCache cache, JsonBranch branch) {
        List instances = cache.get(branch.getJsonPath());
        ArrayList<String> values = new ArrayList<String>();
        if (instances != null) {
            for (XmlFieldInstance instance : instances) {
                values.add(instance.getValue());
            }
        }
        return values;
    }

    private static String extractFirst(JsonPathCache cache, JsonBranch branch) {
        List<String> list = MarcFactory.extractList(cache, branch);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static MarcRecord createFromFormattedText(String marcRecordAsText) {
        return MarcFactory.createFromFormattedText(Arrays.asList(marcRecordAsText.split("\n")));
    }

    public static MarcRecord createFromFormattedText(String marcRecordAsText, MarcVersion marcVersion) {
        return MarcFactory.createFromFormattedText(Arrays.asList(marcRecordAsText.split("\n")), marcVersion);
    }

    public static MarcRecord createFromFormattedText(List<String> lines) {
        return MarcFactory.createFromFormattedText(lines, MarcVersion.MARC21);
    }

    public static MarcRecord createFromFormattedText(List<String> lines, MarcVersion marcVersion) {
        if (marcVersion == null) {
            marcVersion = MarcVersion.MARC21;
        }
        MarcRecord record = new MarcRecord();
        for (String line : lines) {
            if (line.startsWith("LEADER ")) {
                record.setLeader(line.replace("LEADER ", ""), marcVersion);
                continue;
            }
            String tag = line.substring(0, 3);
            String content = line.substring(4);
            record.setField(tag, content, marcVersion);
        }
        return record;
    }

    public static MarcRecord createFromAlephseq(List<AlephseqLine> lines, MarcVersion marcVersion) {
        if (marcVersion == null) {
            marcVersion = MarcVersion.MARC21;
        }
        MarcRecord record = new MarcRecord();
        for (AlephseqLine line : lines) {
            if (line.isLeader()) {
                record.setLeader(line.getContent());
                continue;
            }
            if (!line.isNumericTag()) continue;
            record.setField(line.getTag(), line.getInd1(), line.getInd2(), line.getContent(), marcVersion);
        }
        return record;
    }

    public static Record createRecordFromAlephseq(List<AlephseqLine> lines) {
        RecordImpl record = new RecordImpl();
        boolean deleted = false;
        for (AlephseqLine line : lines) {
            if (line.isLeader()) {
                record.setLeader((org.marc4j.marc.Leader)new LeaderImpl(line.getContent()));
                continue;
            }
            if (!line.isNumericTag()) continue;
            if (line.isControlField()) {
                record.addVariableField((VariableField)new ControlFieldImpl(line.getTag(), line.getContent()));
                continue;
            }
            DataFieldImpl df = new DataFieldImpl(line.getTag(), line.getInd1().charAt(0), line.getInd2().charAt(0));
            for (String[] pair : line.parseSubfields()) {
                if (pair.length == 2 && pair[0] != null && pair[1] != null) {
                    df.addSubfield((Subfield)new SubfieldImpl(pair[0].charAt(0), pair[1]));
                    continue;
                }
                logger.warning(String.format("parse error in record #%s) tag %s: '%s'", line.getRecordID(), line.getTag(), line.getRawContent()));
            }
            record.addVariableField((VariableField)df);
        }
        return record;
    }

    public static Record createRecordFromPica(List<PicaLine> lines) {
        RecordImpl record = new RecordImpl();
        for (PicaLine line : lines) {
            if (line.isLeader()) {
                record.setLeader((org.marc4j.marc.Leader)new LeaderImpl(line.getContent()));
                continue;
            }
            if (!line.isNumericTag() || !line.isControlField()) continue;
            record.addVariableField((VariableField)new ControlFieldImpl(line.getTag(), line.getContent()));
        }
        return record;
    }
}

