/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.marc.Extractable;
import de.gwdg.metadataqa.marc.Validatable;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MarcControlField
implements Validatable,
Extractable,
Serializable {
    protected DataFieldDefinition definition;
    protected String content;
    protected List<ValidationError> initializationErrors = new ArrayList<ValidationError>();
    protected List<ValidationError> validationErrors;

    public MarcControlField() {
    }

    public MarcControlField(DataFieldDefinition definition, String content) {
        this.definition = definition;
        this.content = content;
    }

    public DataFieldDefinition getDefinition() {
        return this.definition;
    }

    public String getContent() {
        return this.content;
    }

    public String getSolrKey(SolrFieldType type, String tag, String mqTag) {
        String key = tag;
        switch (type) {
            case HUMAN: {
                key = mqTag;
                break;
            }
            case MIXED: {
                key = String.format("%s_%s", tag, mqTag);
                break;
            }
            default: {
                key = tag;
            }
        }
        return key;
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs() {
        return this.getKeyValuePairs(SolrFieldType.MARC);
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        map.put(this.getSolrKey(type, this.definition.getTag(), this.definition.getMqTag()), Arrays.asList(this.content));
        return map;
    }

    @Override
    public boolean validate(MarcVersion marcVersion) {
        return true;
    }

    @Override
    public List<ValidationError> getValidationErrors() {
        return null;
    }
}

