/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.marc.Extractable;
import de.gwdg.metadataqa.marc.MarcPositionalControlField;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.Validatable;
import de.gwdg.metadataqa.marc.definition.ControlValue;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.controlpositions.LeaderPositions;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.definition.tags.control.LeaderDefinition;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import de.gwdg.metadataqa.marc.utils.keygenerator.PositionalControlFieldKeyGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Leader
extends MarcPositionalControlField
implements Extractable,
Validatable,
Serializable {
    private static final Logger logger = Logger.getLogger(Leader.class.getCanonicalName());
    private Type type;
    private Type defaultType = null;
    private ControlValue recordLength;
    private ControlValue recordStatus;
    private ControlValue typeOfRecord;
    private ControlValue bibliographicLevel;
    private ControlValue typeOfControl;
    private ControlValue characterCodingScheme;
    private ControlValue indicatorCount;
    private ControlValue subfieldCodeCount;
    private ControlValue baseAddressOfData;
    private ControlValue encodingLevel;
    private ControlValue descriptiveCatalogingForm;
    private ControlValue multipartResourceRecordLevel;
    private ControlValue lengthOfTheLengthOfFieldPortion;
    private ControlValue lengthOfTheStartingCharacterPositionPortion;
    private ControlValue lengthOfTheImplementationDefinedPortion;
    private List<ValidationError> initializationErrors;
    private List<ValidationError> validationErrors;

    public Leader(String content) {
        super(LeaderDefinition.getInstance(), content);
        this.initialize();
    }

    public Leader(String content, Type defaultType) {
        super(LeaderDefinition.getInstance(), content);
        this.defaultType = defaultType;
        this.initialize();
    }

    private void initialize() {
        this.initializationErrors = new ArrayList<ValidationError>();
        this.processContent();
        try {
            this.setType();
        }
        catch (IllegalArgumentException e) {
            String string = this.definition.getTag();
            String string2 = e.getMessage();
            LeaderPositions.getInstance();
            this.initializationErrors.add(new ValidationError(null, string, ValidationErrorType.RECORD_UNDETECTABLE_TYPE, string2, LeaderPositions.getPositionList().get(0).getDescriptionUrl()));
        }
    }

    @Override
    protected void processContent() {
        LeaderPositions.getInstance();
        for (ControlfieldPositionDefinition subfield : LeaderPositions.getPositionList()) {
            int end = Math.min(this.content.length(), subfield.getPositionEnd());
            try {
                String value = this.content.substring(subfield.getPositionStart(), end);
                ControlValue controlValue = new ControlValue(subfield, value);
                this.valuesList.add(controlValue);
                switch (subfield.getId()) {
                    case "leader00": {
                        this.recordLength = controlValue;
                        break;
                    }
                    case "leader05": {
                        this.recordStatus = controlValue;
                        break;
                    }
                    case "leader06": {
                        this.typeOfRecord = controlValue;
                        break;
                    }
                    case "leader07": {
                        this.bibliographicLevel = controlValue;
                        break;
                    }
                    case "leader08": {
                        this.typeOfControl = controlValue;
                        break;
                    }
                    case "leader09": {
                        this.characterCodingScheme = controlValue;
                        break;
                    }
                    case "leader10": {
                        this.indicatorCount = controlValue;
                        break;
                    }
                    case "leader11": {
                        this.subfieldCodeCount = controlValue;
                        break;
                    }
                    case "leader12": {
                        this.baseAddressOfData = controlValue;
                        break;
                    }
                    case "leader17": {
                        this.encodingLevel = controlValue;
                        break;
                    }
                    case "leader18": {
                        this.descriptiveCatalogingForm = controlValue;
                        break;
                    }
                    case "leader19": {
                        this.multipartResourceRecordLevel = controlValue;
                        break;
                    }
                    case "leader20": {
                        this.lengthOfTheLengthOfFieldPortion = controlValue;
                        break;
                    }
                    case "leader21": {
                        this.lengthOfTheStartingCharacterPositionPortion = controlValue;
                        break;
                    }
                    case "leader22": {
                        this.lengthOfTheImplementationDefinedPortion = controlValue;
                        break;
                    }
                }
                this.valuesMap.put(subfield, value);
            }
            catch (StringIndexOutOfBoundsException e) {
                logger.severe(String.format("Problem with processing Leader ('%s'). The content length is only %d while reading position @%d-%d (for %s)", this.content, this.content.length(), subfield.getPositionStart(), subfield.getPositionEnd(), subfield.getLabel()));
            }
        }
    }

    private void setType() {
        if (this.typeOfRecord.getValue().equals("a") && this.bibliographicLevel.getValue().matches("^(a|c|d|m)$")) {
            this.type = Type.BOOKS;
        } else if (this.typeOfRecord.getValue().equals("a") && this.bibliographicLevel.getValue().matches("^(b|i|s)$")) {
            this.type = Type.CONTINUING_RESOURCES;
        } else if (this.typeOfRecord.getValue().equals("t")) {
            this.type = Type.BOOKS;
        } else if (this.typeOfRecord.getValue().matches("^[cdij]$")) {
            this.type = Type.MUSIC;
        } else if (this.typeOfRecord.getValue().matches("^[ef]$")) {
            this.type = Type.MAPS;
        } else if (this.typeOfRecord.getValue().matches("^[gkor]$")) {
            this.type = Type.VISUAL_MATERIALS;
        } else if (this.typeOfRecord.getValue().equals("m")) {
            this.type = Type.COMPUTER_FILES;
        } else if (this.typeOfRecord.getValue().equals("p")) {
            this.type = Type.MIXED_MATERIALS;
        } else {
            if (this.defaultType != null) {
                this.type = this.defaultType;
            }
            throw new IllegalArgumentException(String.format("Leader/%s (%s): '%s', Leader/%s (%s): '%s'", this.typeOfRecord.getDefinition().formatPositon(), this.typeOfRecord.getDefinition().getMqTag(), this.typeOfRecord.getValue(), this.bibliographicLevel.getDefinition().formatPositon(), this.bibliographicLevel.getDefinition().getMqTag(), this.bibliographicLevel.getValue()));
        }
    }

    public String resolve(ControlfieldPositionDefinition key) {
        String value = (String)this.valuesMap.get(key);
        String text = key.resolve(value);
        return text;
    }

    public String resolve(String key) {
        return this.resolve(LeaderPositions.getByLabel(key));
    }

    @Override
    public Map<ControlfieldPositionDefinition, String> getMap() {
        return this.valuesMap;
    }

    public String get(ControlfieldPositionDefinition key) {
        return (String)this.valuesMap.get(key);
    }

    public String getByLabel(String key) {
        return this.get(LeaderPositions.getByLabel(key));
    }

    public String getById(String key) {
        return this.get(LeaderPositions.getInstance().getById(key));
    }

    public Type getType() {
        return this.type;
    }

    public String getLeaderString() {
        return this.content;
    }

    public ControlValue getRecordLength() {
        return this.recordLength;
    }

    public ControlValue getRecordStatus() {
        return this.recordStatus;
    }

    public ControlValue getTypeOfRecord() {
        return this.typeOfRecord;
    }

    public ControlValue getBibliographicLevel() {
        return this.bibliographicLevel;
    }

    public ControlValue getTypeOfControl() {
        return this.typeOfControl;
    }

    public ControlValue getCharacterCodingScheme() {
        return this.characterCodingScheme;
    }

    public ControlValue getIndicatorCount() {
        return this.indicatorCount;
    }

    public ControlValue getSubfieldCodeCount() {
        return this.subfieldCodeCount;
    }

    public ControlValue getBaseAddressOfData() {
        return this.baseAddressOfData;
    }

    public ControlValue getEncodingLevel() {
        return this.encodingLevel;
    }

    public ControlValue getDescriptiveCatalogingForm() {
        return this.descriptiveCatalogingForm;
    }

    public ControlValue getMultipartResourceRecordLevel() {
        return this.multipartResourceRecordLevel;
    }

    public ControlValue getLengthOfTheLengthOfFieldPortion() {
        return this.lengthOfTheLengthOfFieldPortion;
    }

    public ControlValue getLengthOfTheStartingCharacterPositionPortion() {
        return this.lengthOfTheStartingCharacterPositionPortion;
    }

    public ControlValue getLengthOfTheImplementationDefinedPortion() {
        return this.lengthOfTheImplementationDefinedPortion;
    }

    @Override
    public void setMarcRecord(MarcRecord marcRecord) {
        this.marcRecord = marcRecord;
        for (ControlValue value : this.valuesList) {
            value.setRecord(marcRecord);
        }
    }

    public String toString() {
        StringBuffer output = new StringBuffer(String.format("type: %s%n", this.type.getValue()));
        LeaderPositions.getInstance();
        for (ControlfieldPositionDefinition key : LeaderPositions.getPositionList()) {
            output.append(String.format("%s: %s%n", key.getLabel(), this.resolve(key)));
        }
        return output.toString();
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs() {
        return this.getKeyValuePairs(SolrFieldType.MARC);
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        PositionalControlFieldKeyGenerator keyGenerator = new PositionalControlFieldKeyGenerator(this.definition.getTag(), this.definition.getMqTag(), type);
        map.put(keyGenerator.forTag(), Arrays.asList(this.content));
        for (Map.Entry entry : this.valuesMap.entrySet()) {
            ControlfieldPositionDefinition position = (ControlfieldPositionDefinition)entry.getKey();
            String value = position.resolve((String)entry.getValue());
            map.put(keyGenerator.forSubfield(position), Arrays.asList(value));
        }
        return map;
    }

    @Override
    public boolean validate(MarcVersion marcVersion) {
        boolean isValid = true;
        this.validationErrors = new ArrayList<ValidationError>();
        if (!this.initializationErrors.isEmpty()) {
            this.validationErrors.addAll(this.initializationErrors);
        }
        for (ControlValue controlValue : this.valuesList) {
            if (controlValue.validate(marcVersion)) continue;
            this.validationErrors.addAll(controlValue.getValidationErrors());
            isValid = false;
        }
        return isValid;
    }

    @Override
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    public static enum Type {
        BOOKS("Books"),
        CONTINUING_RESOURCES("Continuing Resources"),
        MUSIC("Music"),
        MAPS("Maps"),
        VISUAL_MATERIALS("Visual Materials"),
        COMPUTER_FILES("Computer Files"),
        MIXED_MATERIALS("Mixed Materials");

        String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

