/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.marc.Code;
import de.gwdg.metadataqa.marc.Extractable;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.Validatable;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.TagDefinitionLoader;
import de.gwdg.metadataqa.marc.definition.general.Linkage;
import de.gwdg.metadataqa.marc.definition.general.indexer.FieldIndexer;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd1OrIf7FromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd1OrIfEmptyFromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd2AndSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd2For055OrIf7FromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SubjectIndexer;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.ParserException;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import de.gwdg.metadataqa.marc.model.validation.ErrorsCollector;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import de.gwdg.metadataqa.marc.utils.keygenerator.DataFieldKeyGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class DataField
implements Extractable,
Validatable,
Serializable {
    private static final Logger logger = Logger.getLogger(DataField.class.getCanonicalName());
    private DataFieldDefinition definition;
    private String tag;
    private String ind1;
    private String ind2;
    private List<MarcSubfield> subfields;
    private Map<String, List<MarcSubfield>> subfieldIndex = new LinkedHashMap<String, List<MarcSubfield>>();
    private ErrorsCollector errors = null;
    private List<String> unhandledSubfields = null;
    private MarcRecord record;

    public <T extends DataFieldDefinition> DataField(T definition, String ind1, String ind2) {
        this.definition = definition;
        this.ind1 = ind1;
        this.ind2 = ind2;
        this.subfields = new ArrayList<MarcSubfield>();
    }

    public <T extends DataFieldDefinition> DataField(T definition, String ind1, String ind2, List<Map<String, String>> subfields) {
        this(definition, ind1, ind2);
        if (subfields != null) {
            for (Map<String, String> subfield : subfields) {
                String code = subfield.get("code");
                String value = subfield.get("content");
                SubfieldDefinition subfieldDefinition = definition.getSubfield(code);
                if (subfieldDefinition == null) {
                    if (definition.getTag().equals("886") && code.equals("k") || definition.getTag().equals("936")) continue;
                    System.err.printf("no definition for %s$%s (value: '%s') %s %s%n", definition.getTag(), code, value, definition.getTag().equals("886"), code.equals("k"));
                    continue;
                }
                MarcSubfield marcSubfield = new MarcSubfield(subfieldDefinition, code, value);
                marcSubfield.setField(this);
                this.subfields.add(marcSubfield);
                this.indexSubfield(code, marcSubfield);
            }
        }
    }

    public <T extends DataFieldDefinition> DataField(T definition, String ind1, String ind2, String ... subfields) {
        this(definition, ind1, ind2);
        if (subfields != null) {
            this.parseSubfieldArray(subfields);
        }
    }

    public DataField(String tag, String input) {
        this(tag, input, MarcVersion.MARC21);
    }

    public DataField(String tag, String input, MarcVersion version) {
        this.definition = TagDefinitionLoader.load(tag, version);
        if (this.definition == null) {
            this.tag = tag;
        }
        this.subfields = new ArrayList<MarcSubfield>();
        this.ind1 = input.substring(0, 1);
        this.ind2 = input.substring(1, 2);
        this.parseAndAddSubfields(input.substring(2));
    }

    public DataField(String tag, String ind1, String ind2, MarcVersion marcVersion) {
        this.definition = TagDefinitionLoader.load(tag, marcVersion);
        if (this.definition == null) {
            this.tag = tag;
        }
        this.ind1 = ind1;
        this.ind2 = ind2;
        this.subfields = new ArrayList<MarcSubfield>();
    }

    public DataField(String tag, String ind1, String ind2, String content, MarcVersion marcVersion) {
        this.definition = TagDefinitionLoader.load(tag, marcVersion);
        if (this.definition == null) {
            this.tag = tag;
        }
        this.ind1 = ind1;
        this.ind2 = ind2;
        this.subfields = new ArrayList<MarcSubfield>();
        this.parseAndAddSubfields(content);
    }

    private void parseAndAddSubfields(String content) {
        for (String[] sf : DataField.parseSubfields(content)) {
            this.addSubfield(sf[0], sf[1]);
        }
    }

    public static List<String[]> parseSubfields(String content) {
        ArrayList<String[]> subfields = new ArrayList<String[]>();
        boolean codeFlag = false;
        String code = null;
        StringBuffer value = new StringBuffer();
        for (int i = 0; i < content.length(); ++i) {
            String c = Character.toString(content.charAt(i));
            if (c.equals("$")) {
                codeFlag = true;
                if (code != null) {
                    subfields.add(new String[]{code, value.toString()});
                }
                code = null;
                value = new StringBuffer();
                continue;
            }
            if (codeFlag) {
                code = c;
                codeFlag = false;
                continue;
            }
            value.append(c);
        }
        subfields.add(new String[]{code, value.toString()});
        return subfields;
    }

    public MarcRecord getRecord() {
        return this.record;
    }

    public void setRecord(MarcRecord record) {
        this.record = record;
        for (MarcSubfield marcSubfield : this.subfields) {
            marcSubfield.setRecord(record);
        }
    }

    public void indexSubfields() {
        for (MarcSubfield marcSubfield : this.subfields) {
            this.indexSubfield(marcSubfield.getCode(), marcSubfield);
        }
    }

    private void indexSubfield(String code, MarcSubfield marcSubfield) {
        if (!this.subfieldIndex.containsKey(code)) {
            this.subfieldIndex.put(code, new LinkedList());
        }
        this.subfieldIndex.get(code).add(marcSubfield);
    }

    private void parseSubfieldArray(String[] subfields) {
        for (int i = 0; i < subfields.length; i += 2) {
            String code = subfields[i];
            String value = subfields[i + 1];
            this.addSubfield(code, value);
        }
    }

    private void addSubfield(String code, String value) {
        SubfieldDefinition subfieldDefinition = this.definition != null ? this.definition.getSubfield(code) : null;
        MarcSubfield marcSubfield = new MarcSubfield(subfieldDefinition, code, value);
        marcSubfield.setField(this);
        this.subfields.add(marcSubfield);
        this.indexSubfield(code, marcSubfield);
    }

    public Map<String, List<String>> getHumanReadableMap() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        if (this.definition.getInd1().exists()) {
            map.put(this.definition.getInd1().getLabel(), Arrays.asList(this.resolveInd1()));
        }
        if (this.definition.getInd2().exists()) {
            map.put(this.definition.getInd2().getLabel(), Arrays.asList(this.resolveInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            if (!map.containsKey(subfield.getLabel())) {
                map.put(subfield.getLabel(), new ArrayList());
            }
            ((List)map.get(subfield.getLabel())).add(subfield.resolve());
        }
        return map;
    }

    public String simpleFormat() {
        StringBuffer output = new StringBuffer();
        output.append(this.ind1);
        output.append(this.ind2);
        output.append(" ");
        for (MarcSubfield subfield : this.subfields) {
            output.append(String.format("$%s%s", subfield.getDefinition().getCode(), subfield.getValue()));
        }
        return output.toString();
    }

    public String format() {
        StringBuffer output = new StringBuffer();
        if (this.definition != null) {
            output.append(String.format("[%s: %s]%n", this.definition.getTag(), this.definition.getLabel()));
        } else {
            output.append(String.format("[%s]%n", this.getTag()));
        }
        if (this.definition != null && this.definition.getInd1().exists()) {
            output.append(String.format("%s: %s%n", this.definition.getInd1().getLabel(), this.resolveInd1()));
        } else if (StringUtils.isNotBlank((CharSequence)this.getInd1())) {
            output.append(String.format("ind1: %s%n", this.getInd1()));
        }
        if (this.definition != null && this.definition.getInd2().exists()) {
            output.append(String.format("%s: %s%n", this.definition.getInd2().getLabel(), this.resolveInd2()));
        } else if (StringUtils.isNotBlank((CharSequence)this.getInd2())) {
            output.append(String.format("ind2: %s%n", this.getInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            output.append(String.format("%s: %s%n", subfield.getLabel(), subfield.resolve()));
        }
        return output.toString();
    }

    public String formatAsText() {
        StringBuffer output = new StringBuffer();
        output.append(this.getTag());
        output.append(" ").append(this.ind1).append(this.ind2).append(" ");
        boolean first = true;
        for (MarcSubfield subfield : this.subfields) {
            if (!first) {
                output.append("       ");
            }
            output.append("$").append(subfield.getCode()).append(" ").append(subfield.getValue()).append("\n");
            first = false;
        }
        return output.toString();
    }

    public String formatAsMarc() {
        StringBuffer output = new StringBuffer();
        if (this.definition != null && this.definition.getInd1().exists()) {
            output.append(String.format("%s_ind1: %s%n", this.getTag(), this.resolveInd1()));
        }
        if (this.definition != null && this.definition.getInd2().exists()) {
            output.append(String.format("%s_ind2: %s%n", this.getTag(), this.resolveInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            output.append(String.format("%s_%s: %s%n", this.getTag(), subfield.getCode(), subfield.resolve()));
        }
        return output.toString();
    }

    public String formatForIndex() {
        StringBuffer output = new StringBuffer();
        if (this.definition.getInd1().exists()) {
            output.append(String.format("%s_ind1: %s%n", this.definition.getIndexTag(), this.resolveInd1()));
        }
        if (this.definition.getInd2().exists()) {
            output.append(String.format("%s_ind2: %s%n", this.definition.getIndexTag(), this.resolveInd2()));
        }
        for (MarcSubfield subfield : this.subfields) {
            Map<String, String> extra;
            String code = subfield.getCodeForIndex();
            output.append(String.format("%s%s: %s%n", this.definition.getIndexTag(), code, subfield.resolve()));
            if (subfield.getDefinition() == null || !subfield.getDefinition().hasContentParser() || (extra = subfield.parseContent()) == null) continue;
            for (Map.Entry<String, String> entry : extra.entrySet()) {
                output.append(String.format("%s%s_%s: %s%n", this.definition.getIndexTag(), code, entry.getKey(), entry.getValue()));
            }
        }
        return output.toString();
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs() {
        return this.getKeyValuePairs(SolrFieldType.MARC);
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type) {
        String value;
        HashMap<String, List<String>> pairs = new HashMap<String, List<String>>();
        DataFieldKeyGenerator keyGenerator = new DataFieldKeyGenerator(this.definition, type, this.getTag());
        String string = this.definition != null && this.definition.getInd1().exists() ? this.resolveInd1() : (value = this.getInd1() != null ? this.getInd1() : null);
        if (value != null && StringUtils.isNotBlank((CharSequence)value)) {
            pairs.put(keyGenerator.forInd1(), Arrays.asList(value));
        }
        String string2 = this.definition != null && this.definition.getInd2().exists() ? this.resolveInd2() : (value = this.getInd2() != null ? this.getInd2() : null);
        if (value != null && StringUtils.isNotBlank((CharSequence)value)) {
            pairs.put(keyGenerator.forInd2(), Arrays.asList(value));
        }
        for (MarcSubfield subfield : this.subfields) {
            pairs.putAll(subfield.getKeyValuePairs(keyGenerator));
        }
        if (this.getFieldIndexer() != null) {
            try {
                Map<String, List<String>> extra = this.getFieldIndexer().index(this, keyGenerator);
                pairs.putAll(extra);
            }
            catch (IllegalArgumentException e) {
                logger.severe(String.format("%s  in record %s %s", e.getLocalizedMessage(), this.record.getId(), this.toString()));
            }
        }
        return pairs;
    }

    public FieldIndexer getFieldIndexer() {
        SubjectIndexer fieldIndexer = null;
        if (this.definition != null && this.definition.getSourceSpecificationType() != null) {
            SourceSpecificationType specificationType = this.definition.getSourceSpecificationType();
            switch (specificationType) {
                case Indicator1Is7AndSubfield2: {
                    fieldIndexer = SchemaFromInd1OrIf7FromSubfield2.getInstance();
                    break;
                }
                case Indicator1IsSpaceAndSubfield2: {
                    fieldIndexer = SchemaFromInd1OrIfEmptyFromSubfield2.getInstance();
                    break;
                }
                case Indicator2AndSubfield2: {
                    fieldIndexer = SchemaFromInd2AndSubfield2.getInstance();
                    break;
                }
                case Indicator2For055AndSubfield2: {
                    fieldIndexer = SchemaFromInd2For055OrIf7FromSubfield2.getInstance();
                    break;
                }
                case Subfield2: {
                    fieldIndexer = SchemaFromSubfield2.getInstance();
                    break;
                }
                case Indicator2: {
                    fieldIndexer = SchemaFromInd2.getInstance();
                }
            }
        }
        return fieldIndexer;
    }

    public String resolveInd1() {
        return this.resolveIndicator(this.definition.getInd1(), this.ind1);
    }

    public String resolveInd2() {
        return this.resolveIndicator(this.definition.getInd2(), this.ind2);
    }

    public String resolveIndicator(Indicator indicatorDefinition, String indicator) {
        if (indicatorDefinition == null) {
            return indicator;
        }
        if (!indicatorDefinition.exists()) {
            return indicator;
        }
        if (!indicatorDefinition.hasCode(indicator)) {
            return indicator;
        }
        Code indCode = indicatorDefinition.getCode(indicator);
        assert (indCode != null);
        if (indCode.isRange()) {
            return indCode.getLabel() + ": " + indicator;
        }
        return indCode.getLabel();
    }

    public String getTag() {
        return this.definition != null ? this.definition.getTag() : this.tag;
    }

    public String getInd1() {
        return this.ind1;
    }

    public String getInd2() {
        return this.ind2;
    }

    public List<MarcSubfield> getSubfield(String code) {
        return this.subfieldIndex.getOrDefault(code, null);
    }

    public List<MarcSubfield> getSubfields() {
        return this.subfields;
    }

    public DataFieldDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public boolean validate(MarcVersion marcVersion) {
        boolean isValid = true;
        this.errors = new ErrorsCollector();
        DataFieldDefinition referencerDefinition = null;
        List<MarcSubfield> _subfields = null;
        boolean ambiguousLinkage = false;
        if (marcVersion == null) {
            marcVersion = MarcVersion.MARC21;
        }
        if (TagDefinitionLoader.load(this.definition.getTag(), marcVersion) == null) {
            this.addError(ValidationErrorType.FIELD_UNDEFINED, "");
            return false;
        }
        if (this.getTag().equals("880")) {
            List<MarcSubfield> subfield6s = this.getSubfield("6");
            if (subfield6s == null) {
                this.addError(ValidationErrorType.FIELD_MISSING_REFERENCE_SUBFIELD, "$6");
                isValid = false;
            } else if (!subfield6s.isEmpty()) {
                if (subfield6s.size() != 1) {
                    this.addError(this.definition.getTag() + "$6", ValidationErrorType.RECORD_AMBIGUOUS_LINKAGE, "There are multiple $6");
                    isValid = false;
                    ambiguousLinkage = true;
                } else {
                    MarcSubfield subfield6 = subfield6s.get(0);
                    Object var8_8 = null;
                    try {
                        String message;
                        Linkage linkage = LinkageParser.getInstance().create(subfield6.getValue());
                        if (linkage == null || linkage.getLinkingTag() == null) {
                            message = String.format("Unparseable reference: '%s'", subfield6.getValue());
                            this.addError(ValidationErrorType.RECORD_INVALID_LINKAGE, message);
                        } else {
                            referencerDefinition = this.definition;
                            this.definition = TagDefinitionLoader.load(linkage.getLinkingTag(), marcVersion);
                            if (this.definition == null) {
                                this.definition = referencerDefinition;
                                message = String.format("refers to field %s, which is not defined", linkage.getLinkingTag());
                                this.addError(this.definition.getTag() + "$6", ValidationErrorType.RECORD_INVALID_LINKAGE, message);
                                isValid = false;
                            } else {
                                _subfields = this.subfields;
                                ArrayList<MarcSubfield> _subfieldsNew = new ArrayList<MarcSubfield>();
                                for (MarcSubfield subfield : this.subfields) {
                                    MarcSubfield alternativeSubfield = new MarcSubfield(this.definition.getSubfield(subfield.getCode()), subfield.getCode(), subfield.getValue());
                                    alternativeSubfield.setField(this);
                                    alternativeSubfield.setRecord(this.record);
                                    alternativeSubfield.setLinkage(linkage);
                                    alternativeSubfield.setReferencePath(referencerDefinition.getTag());
                                    _subfieldsNew.add(alternativeSubfield);
                                }
                                this.subfields = _subfieldsNew;
                            }
                        }
                    }
                    catch (ParserException e) {
                        this.addError(this.definition.getTag() + "$6", ValidationErrorType.RECORD_INVALID_LINKAGE, e.getMessage());
                    }
                }
            }
        }
        if (this.unhandledSubfields != null) {
            this.addError(ValidationErrorType.SUBFIELD_UNDEFINED, StringUtils.join(this.unhandledSubfields, (String)", "));
            isValid = false;
        }
        if (this.ind1 != null && !this.validateIndicator(this.definition.getInd1(), this.ind1, marcVersion, referencerDefinition)) {
            isValid = false;
        }
        if (this.ind2 != null && !this.validateIndicator(this.definition.getInd2(), this.ind2, marcVersion, referencerDefinition)) {
            isValid = false;
        }
        if (!ambiguousLinkage) {
            HashMap counter = new HashMap();
            for (MarcSubfield marcSubfield : this.subfields) {
                if (marcSubfield.getDefinition() == null) {
                    if (this.definition.isVersionSpecificSubfields(marcVersion, marcSubfield.getCode())) {
                        marcSubfield.setDefinition(this.definition.getVersionSpecificSubfield(marcVersion, marcSubfield.getCode()));
                    } else {
                        this.addError(ValidationErrorType.SUBFIELD_UNDEFINED, marcSubfield.getCode());
                        isValid = false;
                        continue;
                    }
                }
                Utils.count(marcSubfield.getDefinition(), counter);
                if (marcSubfield.validate(marcVersion)) continue;
                this.errors.addAll(marcSubfield.getValidationErrors());
                isValid = false;
            }
            for (Map.Entry entry : counter.entrySet()) {
                SubfieldDefinition subfieldDefinition = (SubfieldDefinition)entry.getKey();
                Integer count = (Integer)entry.getValue();
                if (count <= 1 || !subfieldDefinition.getCardinality().equals((Object)Cardinality.Nonrepeatable)) continue;
                this.addError(subfieldDefinition, ValidationErrorType.SUBFIELD_NONREPEATABLE, String.format("there are %d instances", count));
                isValid = false;
            }
        }
        if (referencerDefinition != null) {
            this.definition = referencerDefinition;
        }
        if (_subfields != null) {
            this.subfields = _subfields;
        }
        return isValid;
    }

    private boolean validateIndicator(Indicator indicatorDefinition, String value, MarcVersion marcVersion, DataFieldDefinition referencerDefinition) {
        boolean isValid = true;
        String path = indicatorDefinition.getPath();
        if (referencerDefinition != null) {
            path = String.format("%s->%s", referencerDefinition.getTag(), path);
        }
        if (indicatorDefinition.exists()) {
            if (!indicatorDefinition.hasCode(value) && !indicatorDefinition.isVersionSpecificCode(marcVersion, value)) {
                isValid = false;
                if (indicatorDefinition.isHistoricalCode(value)) {
                    this.addError(path, ValidationErrorType.INDICATOR_OBSOLETE, value);
                } else {
                    this.addError(path, ValidationErrorType.INDICATOR_INVALID_VALUE, value);
                }
            }
        } else if (!value.equals(" ") && !indicatorDefinition.isVersionSpecificCode(marcVersion, value)) {
            this.addError(path, ValidationErrorType.INDICATOR_NON_EMPTY, value);
            isValid = false;
        }
        return isValid;
    }

    public DataFieldKeyGenerator getKeyGenerator(SolrFieldType type) {
        return new DataFieldKeyGenerator(this.getDefinition(), type);
    }

    @Override
    public List<ValidationError> getValidationErrors() {
        return this.errors.getErrors();
    }

    public void addUnhandledSubfields(String code) {
        if (this.unhandledSubfields == null) {
            this.unhandledSubfields = new ArrayList<String>();
        }
        this.unhandledSubfields.add(code);
    }

    private void addError(ValidationErrorType type, String message) {
        this.addError(this.definition.getTag(), type, message);
    }

    private void addError(SubfieldDefinition subfieldDefinition, ValidationErrorType type, String message) {
        this.addError(subfieldDefinition.getPath(), type, message);
    }

    private void addError(String path, ValidationErrorType type, String message) {
        String url = this.definition.getDescriptionUrl();
        this.errors.add(this.record.getId(), path, type, message, url);
    }

    public String toString() {
        return "DataField{" + (StringUtils.isNotBlank((CharSequence)this.tag) ? this.tag : (this.definition != null ? this.definition.getTag() : "unknown")) + ", ind1='" + this.ind1 + '\'' + ", ind2='" + this.ind2 + '\'' + ", subfields=" + this.subfields + '}';
    }
}

