package de.gwdg.metadataqa.marc.definition.tags.tags6xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

import java.util.Arrays;

/**
 * Subject Added Entry - Named Event
 * http://www.loc.gov/marc/bibliographic/bd647.html
 */
public class Tag647 extends DataFieldDefinition {

  private static Tag647 uniqueInstance;

  private Tag647() {
    initialize();
    postCreation();
  }

  public static Tag647 getInstance() {
    if (uniqueInstance == null)
      uniqueInstance = new Tag647();
    return uniqueInstance;
  }

  private void initialize() {
    tag = "647";
    label = "Subject Added Entry - Named Event";
    mqTag = "NamedEvent";
    cardinality = Cardinality.Repeatable;
    descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd647.html";

    ind1 = new Indicator();
    ind2 = new Indicator("Thesaurus")
      .setCodes(
        "0", "Library of Congress Subject Headings",
        "1", "LC subject headings for children's literature",
        "2", "Medical Subject Headings",
        "3", "National Agricultural Library subject authority file",
        "4", "Source not specified",
        "5", "Canadian Subject Headings",
        "6", "Répertoire de vedettes-matière",
        "7", "Source specified in subfield $2"
      )
      .setMqTag("thesaurus");

    setSubfieldsWithCardinality(
      "a", "Named event", "NR",
      "c", "Location of named event", "R",
      "d", "Date of named event", "NR",
      "g", "Miscellaneous information", "R",
      "v", "Form subdivision", "R",
      "x", "General subdivision", "R",
      "y", "Chronological subdivision", "R",
      "z", "Geographic subdivision", "R",
      "0", "Authority record control number or standard number", "R",
      "2", "Source of heading or term", "NR",
      "3", "Materials specified", "NR",
      "6", "Linkage", "NR",
      "8", "Field link and sequence number", "R"
    );

    getSubfield("6").setContentParser(LinkageParser.getInstance());

    getSubfield("a")
      .setMqTag("rdf:value");

    getSubfield("c")
      .setMqTag("location");

    getSubfield("d")
      .setMqTag("date");

    getSubfield("g")
      .setMqTag("miscellaneous");

    getSubfield("v")
      .setBibframeTag("formGenre").setMqTag("formSubdivision");

    getSubfield("x")
      .setBibframeTag("topic").setMqTag("generalSubdivision");

    getSubfield("y")
      .setBibframeTag("temporal").setMqTag("chronologicalSubdivision");

    getSubfield("z")
      .setBibframeTag("geographic").setMqTag("geographicSubdivision");

    getSubfield("0")
      .setMqTag("authorityRecordControlNumber");

    getSubfield("2")
      .setMqTag("source");

    getSubfield("3")
      .setMqTag("materialsSpecified");

    getSubfield("6")
      .setBibframeTag("linkage");

    getSubfield("8")
      .setMqTag("fieldLink");
    
    putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(
      new SubfieldDefinition("7", "NKCR Authority ID", "NR")
    ));

    sourceSpecificationType = SourceSpecificationType.Indicator2AndSubfield2;
  }
}
