package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import static de.gwdg.metadataqa.marc.definition.FRBRFunction.*;

import java.util.Arrays;

/**
 * National Library of Medicine Call Number
 * http://www.loc.gov/marc/bibliographic/bd060.html
 */
public class Tag060 extends DataFieldDefinition {

  private static Tag060 uniqueInstance;

  private Tag060() {
    initialize();
    postCreation();
  }

  public static Tag060 getInstance() {
    if (uniqueInstance == null)
      uniqueInstance = new Tag060();
    return uniqueInstance;
  }

  private void initialize() {

    tag = "060";
    label = "National Library of Medicine Call Number";
    bibframeTag = "ClassificationNlm";
    cardinality = Cardinality.Repeatable;
    descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd060.html";
    setCompilanceLevels("O");

    ind1 = new Indicator("Existence in NLM collection")
      .setCodes(
        " ", "No information provided",
        "0", "Item is in NLM",
        "1", "Item is not in NLM"
      )
      .setMqTag("existenceInNLM")
      .setFrbrFunctions(DiscoverySelect, DiscoveryObtain);

    ind2 = new Indicator("Source of call number")
      .setCodes(
        "0", "Assigned by NLM",
        "4", "Assigned by agency other than NLM"
      )
      .setHistoricalCodes(
        "0", "No series involved",
        "1", "Main series",
        "2", "Subseries",
        "3", "Sub-subseries",
        " ", "No information provided [OBSOLETE]"
      )
      .setMqTag("source")
      .setFrbrFunctions(ManagementIdentify, ManagementProcess);

    setSubfieldsWithCardinality(
      "a", "Classification number", "R",
      "b", "Item number", "NR",
      "0", "Authority record control number or standard number", "R",
      "8", "Field link and sequence number", "R"
    );

    getSubfield("a")
      .setBibframeTag("classificationPortion")
      .setFrbrFunctions(DiscoverySearch, DiscoveryIdentify, DiscoveryObtain)
      .setCompilanceLevels("M");

    getSubfield("b")
      .setBibframeTag("itemPortion")
      .setFrbrFunctions(DiscoverySearch, DiscoveryIdentify, DiscoveryObtain)
      .setCompilanceLevels("A");

    getSubfield("0")
      .setMqTag("authorityRecordControlNumber");

    getSubfield("8").setMqTag("fieldLink")
      .setFrbrFunctions(ManagementIdentify, ManagementProcess)
      .setCompilanceLevels("O");

    putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(
      new SubfieldDefinition("7", "NKCR Authority ID", "NR")
    ));
  }
}
