import networkx as nx

G = nx.read_edgelist("/home/kiru/bin/marc/_output/gent/network-pairs.csv", nodetype=int)
print('nodes: ', G.number_of_nodes())
print('edges: ', G.number_of_edges())

average_degree = 2 * G.number_of_edges() / G.number_of_nodes()
print('average_degree: ', average_degree)

# degree distribution
degree_hist = {}
for node_id, degree in G.degree():
  if not degree in degree_hist:
    degree_hist[degree] = (0, 0)
  degree_hist[degree] = (degree_hist[degree][0] + 1, 0)

for degree, properties in degree_hist.items():
  degree_hist[degree] = (properties[0], properties[0] / G.number_of_nodes())

print('total_degree: ', sorted(degree_hist.items()))

# clusreing coeeficient
for nid, coeff in nx.clustering(G).items():
  # print(nid, ': ', coeff)
  continue

# number of connected components
number_connected_components = nx.number_connected_components(G)
print('number_connected_components: ', number_connected_components)

shown = False
for c in sorted(nx.connected_components(G), key=len, reverse=True):
  print('size: ', len(c))
  S = G.subgraph(c).copy()
  if shown == True:
    diameter = nx.algorithms.distance_measures.diameter(S)
    print('diameter: ', diameter)
  average_path_length = nx.algorithms.shortest_paths.generic.average_shortest_path_length(S)
  print('average_path_length: ', average_path_length)
  shown = True


# diameter
# diameter = nx.algorithms.distance_measures.diameter(G)
# print('diameter: ', diameter)

# print(list(G.degree))
# values = list(G.degree).values()
# print(list(values))