/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils;

import de.gwdg.metadataqa.api.model.JsonPathCache;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MarcCacheWrapper {
    private JsonPathCache<? extends XmlFieldInstance> cache;
    private static final List<String> controlfields = Arrays.asList("001", "003", "005", "006", "007", "008");

    public MarcCacheWrapper(JsonPathCache<? extends XmlFieldInstance> cache) {
        this.cache = cache;
    }

    public String extractCompact(String tag) {
        String[] parts = tag.split("\\$");
        if (parts.length == 1) {
            return this.extract(tag);
        }
        return this.extract(parts[0], parts[1]);
    }

    public String extract(String tag) {
        return this.extract(tag, 0, null);
    }

    public String extract(String tag, String code) {
        return this.extract(tag, 0, code);
    }

    public String extract(String tag, int counter, String code) {
        List list;
        String value = null;
        String path = this.createPath(tag, counter, code);
        if (path != null && (list = (List)this.cache.getCache().get(path)) != null && !list.isEmpty() && list.get(0) != null) {
            value = this.extractValues(path);
        }
        return value;
    }

    private String createPath(String tag, int counter, String code) {
        String path = null;
        path = tag.equals("leader") ? "$.leader" : (this.isControlField(tag) ? String.format("$.controlfield[?(@.tag == '%s')].content", tag) : String.format("$.datafield[?(@.tag == '%s')]/%d/$.%s", tag, counter, this.getSuffix(code)));
        return path;
    }

    private String getSuffix(String code) {
        String suffix = "";
        suffix = code.equals("ind1") || code.equals("ind2") ? code : String.format("subfield[?(@.code == '%s')].content", code);
        return suffix;
    }

    private String extractValues(String path) {
        ArrayList<String> values = new ArrayList<String>();
        for (XmlFieldInstance field : (List)this.cache.getCache().get(path)) {
            if (field.getValue() == null) continue;
            values.add(field.getValue());
        }
        String value = StringUtils.join(values, (String)"|");
        return value;
    }

    private boolean isControlField(String tag) {
        return controlfields.contains(tag);
    }
}

