/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.definition.ControlFieldDefinition;
import de.gwdg.metadataqa.marc.definition.ControlSubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.SubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.controlsubfields.LeaderSubfields;
import de.gwdg.metadataqa.marc.definition.tags.control.Control001Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control003Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control005Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control006Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control007Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.Control008Definition;
import de.gwdg.metadataqa.marc.definition.tags.control.LeaderDefinition;
import de.gwdg.metadataqa.marc.utils.MarcTagLister;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class FrbrFunctionLister {
    private Map<FRBRFunction, Double> collector;
    private Map<FRBRFunction, Integer> baseline;
    private int elementsWithoutFunctions;
    private Map<FRBRFunction, Map<Double, Integer>> histogram;
    private int controlFields = 0;
    private int controlSubfields = 0;
    private int coreFields = 0;
    private int localFields = 0;
    private int coreIndicators = 0;
    private int localIndicators = 0;
    private int coreSubfields = 0;
    private int localSubfields = 0;
    private Map<String, List<FRBRFunction>> functionByMarcPath;

    public FrbrFunctionLister() {
        this.prepareBaseline();
        this.prepareCollector();
        this.prepareHistogram();
        System.err.println("Covered elements: " + this.functionByMarcPath.size());
        System.err.println("Uncovered elements: " + this.elementsWithoutFunctions);
        System.err.println("control fields: " + this.controlFields);
        System.err.println("control subfields: " + this.controlSubfields);
        System.err.println("core fields: " + this.coreFields);
        System.err.println("core indicators: " + this.coreIndicators);
        System.err.println("core subfields: " + this.coreSubfields);
        System.err.println("local fields: " + this.localFields);
        System.err.println("local indicators: " + this.localIndicators);
        System.err.println("local subfields: " + this.localSubfields);
    }

    public Map<FRBRFunction, Map<Double, Integer>> getHistogram() {
        return this.histogram;
    }

    public void prepareBaseline() {
        this.baseline = new TreeMap<FRBRFunction, Integer>();
        this.elementsWithoutFunctions = 0;
        this.functionByMarcPath = new TreeMap<String, List<FRBRFunction>>();
        ++this.controlFields;
        for (ControlSubfieldDefinition controlSubfieldDefinition : LeaderSubfields.getSubfieldList()) {
            ++this.controlSubfields;
            this.processFunctions(controlSubfieldDefinition.getFrbrFunctions(), LeaderDefinition.getInstance().getTag() + "/" + controlSubfieldDefinition.getPositionStart());
        }
        List<DataFieldDefinition> simpleControlFields = Arrays.asList(Control001Definition.getInstance(), Control003Definition.getInstance(), Control005Definition.getInstance());
        for (DataFieldDefinition subfield : simpleControlFields) {
            ++this.controlFields;
            this.processFunctions(subfield.getFrbrFunctions(), subfield.getTag());
        }
        List<ControlFieldDefinition> list = Arrays.asList(Control006Definition.getInstance(), Control007Definition.getInstance(), Control008Definition.getInstance());
        for (ControlFieldDefinition controlFieldDefinition : list) {
            ++this.controlFields;
            for (Map.Entry<String, List<ControlSubfieldDefinition>> entry : controlFieldDefinition.getControlSubfields().entrySet()) {
                String category = entry.getKey();
                for (ControlSubfieldDefinition controlSubfieldDefinition : entry.getValue()) {
                    ++this.controlSubfields;
                    this.processFunctions(controlSubfieldDefinition.getFrbrFunctions(), category + "/" + controlSubfieldDefinition.getPositionStart());
                }
            }
        }
        for (Class clazz : MarcTagLister.listTags()) {
            try {
                Method getInstance = clazz.getMethod("getInstance", new Class[0]);
                DataFieldDefinition fieldTag = (DataFieldDefinition)getInstance.invoke((Object)clazz, new Object[0]);
                boolean isCore = true;
                if (fieldTag.getClass().getCanonicalName().contains("fennicatags") || fieldTag.getClass().getCanonicalName().contains("oclctags") || fieldTag.getClass().getCanonicalName().contains("genttags") || fieldTag.getClass().getCanonicalName().contains("dnbtags") || fieldTag.getClass().getCanonicalName().contains("sztetags")) {
                    isCore = false;
                    ++this.localFields;
                } else {
                    ++this.coreFields;
                }
                System.err.println(fieldTag.getClass());
                ++this.elementsWithoutFunctions;
                for (Indicator indicator : fieldTag.getIndicators()) {
                    if (indicator != null && StringUtils.isNotBlank((CharSequence)indicator.getLabel())) {
                        if (isCore) {
                            ++this.coreIndicators;
                        } else {
                            ++this.localIndicators;
                        }
                    }
                    this.processFunctions(indicator.getFrbrFunctions(), fieldTag.getTag() + "$" + indicator.getIndicatorFlag());
                }
                for (SubfieldDefinition subfieldDefinition : fieldTag.getSubfields()) {
                    if (isCore) {
                        ++this.coreSubfields;
                    } else {
                        ++this.localSubfields;
                    }
                    this.processFunctions(subfieldDefinition.getFrbrFunctions(), fieldTag.getTag() + "$" + subfieldDefinition.getCode());
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void processFunctions(List<FRBRFunction> functions, String key) {
        if (functions != null) {
            this.functionByMarcPath.put(key, functions);
            FrbrFunctionLister.countFunctions(functions, this.baseline);
        } else {
            ++this.elementsWithoutFunctions;
        }
    }

    public static void countFunctions(List<FRBRFunction> functions, Map<FRBRFunction, Integer> map) {
        if (functions != null) {
            for (FRBRFunction function : functions) {
                Utils.count(function, map);
            }
        }
    }

    private void prepareCollector() {
        this.collector = new TreeMap<FRBRFunction, Double>();
        for (FRBRFunction key : this.baseline.keySet()) {
            this.collector.put(key, 0.0);
        }
    }

    private void prepareHistogram() {
        this.histogram = new TreeMap<FRBRFunction, Map<Double, Integer>>();
        for (FRBRFunction key : this.baseline.keySet()) {
            this.histogram.put(key, new TreeMap());
        }
    }

    public Map<FRBRFunction, Double> percent(Map<FRBRFunction, Integer> other) {
        TreeMap<FRBRFunction, Double> percents = new TreeMap<FRBRFunction, Double>();
        for (FRBRFunction key : this.baseline.keySet()) {
            double value = 0.0;
            if (other.containsKey((Object)key)) {
                value = (double)other.get((Object)key).intValue() * 1.0 / (double)this.baseline.get((Object)key).intValue();
            }
            percents.put(key, value);
        }
        return percents;
    }

    public void add(Map<FRBRFunction, Double> other) {
        for (FRBRFunction key : other.keySet()) {
            this.collector.put(key, this.collector.get((Object)key) + other.get((Object)key));
        }
    }

    public Map<FRBRFunction, Double> percentOf(int total) {
        TreeMap<FRBRFunction, Double> result = new TreeMap<FRBRFunction, Double>();
        for (FRBRFunction key : this.collector.keySet()) {
            result.put(key, this.collector.get((Object)key) / (double)total);
        }
        return result;
    }

    public void addToHistogram(Map<FRBRFunction, Double> percent) {
        for (Map.Entry<FRBRFunction, Double> entry : percent.entrySet()) {
            Utils.count(entry.getValue(), this.histogram.get((Object)entry.getKey()));
        }
    }

    public Map<FRBRFunction, Integer> getBaseline() {
        return this.baseline;
    }
}

