/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils;

import de.gwdg.metadataqa.marc.MarcFactory;
import de.gwdg.metadataqa.marc.utils.AlephseqLine;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.marc4j.MarcReader;
import org.marc4j.marc.Record;

public class AlephseqMarcReader
implements MarcReader {
    private static final Logger logger = Logger.getLogger(AlephseqMarcReader.class.getCanonicalName());
    private BufferedReader bufferedReader = null;
    private String line = null;
    private boolean nextIsConsumed = false;
    private int lineNumber = 0;
    private List<AlephseqLine> lines = new ArrayList<AlephseqLine>();
    private String currentId = null;

    public AlephseqMarcReader(String alephseqMarc) {
        try {
            this.bufferedReader = new BufferedReader(new FileReader(alephseqMarc));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasNext() {
        if (this.lineNumber == 0 || this.nextIsConsumed) {
            try {
                this.line = this.bufferedReader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.lineNumber;
            this.nextIsConsumed = false;
        }
        return this.line != null;
    }

    public Record next() {
        Record record = null;
        boolean finished = false;
        while (this.line != null && !finished) {
            AlephseqLine alephseqLine = new AlephseqLine(this.line, this.lineNumber);
            if (this.currentId != null && !alephseqLine.getRecordID().equals(this.currentId) && !this.lines.isEmpty()) {
                record = MarcFactory.createRecordFromAlephseq(this.lines);
                if (record.getLeader() == null) {
                    logger.severe(String.format("Record #%s #%s does not have a leader\n", record.getControlNumberField().getData()));
                } else {
                    finished = true;
                }
                this.lines = new ArrayList<AlephseqLine>();
            }
            if (alephseqLine.isValidTag()) {
                this.lines.add(alephseqLine);
            }
            this.currentId = alephseqLine.getRecordID();
            try {
                this.line = this.bufferedReader.readLine();
                ++this.lineNumber;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.line == null && !this.lines.isEmpty()) {
            record = MarcFactory.createRecordFromAlephseq(this.lines);
        }
        return record;
    }
}

