/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils;

import de.gwdg.metadataqa.marc.DataField;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class AlephseqLine {
    private static final Logger logger = Logger.getLogger(AlephseqLine.class.getCanonicalName());
    private static final String LDR = "LDR";
    private static final Pattern numericTag = Pattern.compile("^\\d\\d\\d$");
    private static final Pattern controlField = Pattern.compile("^00\\d$");
    public static final String SEPARATOR = "\\$\\$";
    private int lineNumber = 0;
    private String recordID;
    private String tag;
    private String ind1;
    private String ind2;
    private String content;
    private boolean valid = true;

    public AlephseqLine() {
    }

    public AlephseqLine(String raw) {
        this.parse(raw);
    }

    public AlephseqLine(String raw, int lineNumber) {
        this.lineNumber = lineNumber;
        this.parse(raw);
    }

    public boolean isLeader() {
        return this.tag.equals(LDR);
    }

    public boolean isNumericTag() {
        return numericTag.matcher(this.tag).matches();
    }

    public boolean isControlField() {
        return controlField.matcher(this.tag).matches();
    }

    public boolean isValidTag() {
        return this.isValid() && (this.isLeader() || this.isNumericTag());
    }

    public String getRecordID() {
        return this.recordID;
    }

    public String getTag() {
        return this.tag;
    }

    public String getInd1() {
        return this.ind1;
    }

    public String getInd2() {
        return this.ind2;
    }

    public String getContent() {
        if (this.isLeader() || this.isControlField()) {
            return this.content.replace("^", " ");
        }
        return this.content.replace("$$", "$");
    }

    public String getRawContent() {
        return this.content;
    }

    private void parse(String raw) {
        if (raw.length() < 18) {
            logger.warning(String.format("%d) short line (%d): '%s'", this.lineNumber, raw.length(), raw));
            this.valid = false;
        } else {
            this.recordID = raw.substring(0, 9);
            this.tag = raw.substring(10, 13);
            this.ind1 = raw.substring(14, 15);
            this.ind2 = raw.substring(15, 16);
            this.content = raw.substring(18);
        }
    }

    public List<String[]> parseSubfields() {
        String[] segments;
        ArrayList<String[]> subfields = new ArrayList<String[]>();
        for (String segment : segments = this.content.split(SEPARATOR)) {
            if (!StringUtils.isNotBlank((String)segment)) continue;
            subfields.add(new String[]{segment.substring(0, 1), segment.substring(1)});
        }
        return subfields;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return "AlephseqLine{recordID='" + this.recordID + '\'' + ", tag='" + this.tag + '\'' + ", ind1='" + this.ind1 + '\'' + ", ind2='" + this.ind2 + '\'' + ", content='" + this.getContent() + '\'' + '}';
    }

    public List<String[]> getSubfields() {
        return DataField.parseSubfields(this.getContent());
    }
}

