/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags84x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.ClassificationSchemeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.CountryCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd1OrIf7FromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag852
extends DataFieldDefinition {
    private static Tag852 uniqueInstance;

    private Tag852() {
        this.initialize();
        this.postCreation();
    }

    public static Tag852 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag852();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "852";
        this.label = "Location";
        this.mqTag = "Location";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd852.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Shelving scheme").setCodes(" ", "No information provided", "0", "Library of Congress classification", "1", "Dewey Decimal classification", "2", "National Library of Medicine classification", "3", "Superintendent of Documents classification", "4", "Shelving control number", "5", "Title", "6", "Shelved separately", "7", "Source specified in subfield $2", "8", "Other scheme").setMqTag("shelvingScheme").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator("Shelving order").setCodes(" ", "No information provided", "0", "Not enumeration", "1", "Primary enumeration", "2", "Alternative enumeration").setMqTag("shelvingOrder");
        this.setSubfieldsWithCardinality("a", "Location", "NR", "b", "Sublocation or collection", "R", "c", "Shelving location", "R", "d", "Former shelving location", "R", "e", "Address", "R", "f", "Coded location qualifier", "R", "g", "Non-coded location qualifier", "R", "h", "Classification part", "NR", "i", "Item part", "R", "j", "Shelving control number", "NR", "k", "Call number prefix", "R", "l", "Shelving form of title", "NR", "m", "Call number suffix", "R", "n", "Country code", "NR", "p", "Piece designation", "NR", "q", "Piece physical condition", "NR", "s", "Copyright article-fee code", "R", "t", "Copy number", "NR", "u", "Uniform Resource Identifier", "R", "x", "Nonpublic note", "R", "z", "Public note", "R", "2", "Source of classification or shelving scheme", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("n").setCodeList(CountryCodes.getInstance());
        this.getSubfield("2").setCodeList(ClassificationSchemeSourceCodes.getInstance()).setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.getSubfield("f").setCodes("l", "Latest", "p", "Previous", " ", "Number of units: No information provided", "1-9", "Number of units", "m", "Month(s) time", "w", "Week(s) time", "y", "Year(s) time", "e", "Edition(s) part", "i", "Issue(s) part", "s", "Supplement(s) part").getCode("1-9").setRange(true);
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("location").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("sublocation").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("shelvingLocation").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("formerShelvingLocation").setCompilanceLevels("O");
        this.getSubfield("e").setMqTag("address").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("O");
        this.getSubfield("f").setMqTag("qualifier").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("O");
        this.getSubfield("g").setMqTag("nonCodedQualifier").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("O");
        this.getSubfield("h").setMqTag("classification").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("i").setMqTag("item").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("shelvingControlNumber").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("k").setMqTag("prefix").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("l").setMqTag("title").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("suffix").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("country").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("O");
        this.getSubfield("p").setMqTag("pieceDesignation").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("q").setMqTag("physicalCondition").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.UseManage).setCompilanceLevels("O");
        this.getSubfield("s").setMqTag("feeCode").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("O");
        this.getSubfield("t").setMqTag("copyNumber").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("u").setMqTag("uri").setCompilanceLevels("A");
        this.getSubfield("x").setMqTag("nonpublicNote").setCompilanceLevels("O");
        this.getSubfield("z").setMqTag("note").setCompilanceLevels("O");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materials").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.fieldIndexer = SchemaFromInd1OrIf7FromSubfield2.getInstance();
    }
}

