/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags76x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.Tag76xSubfield7PositionsGenerator;
import de.gwdg.metadataqa.marc.definition.general.codelist.RelatorCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISBNValidator;
import de.gwdg.metadataqa.marc.definition.general.validator.ISSNValidator;

public class Tag785
extends DataFieldDefinition {
    private static Tag785 uniqueInstance;

    private Tag785() {
        this.initialize();
        this.postCreation();
    }

    public static Tag785 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag785();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "785";
        this.label = "Succeeding Entry";
        this.bibframeTag = "SucceededBy";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd785.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator("Note controller").setCodes("0", "Display note", "1", "Do not display note").setMqTag("noteController").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator("Type of relationship").setCodes("0", "Continued by", "1", "Continued in part by", "2", "Superseded by", "3", "Superseded in part by", "4", "Absorbed by", "5", "Absorbed in part by", "6", "Split into ... and ...", "7", "Merged with ... to form ...", "8", "Changed back to").setMqTag("typeOfRelationship").setFrbrFunctions(FRBRFunction.ManagementDisplay);
        this.setSubfieldsWithCardinality("a", "Main entry heading", "NR", "b", "Edition", "NR", "c", "Qualifying information", "NR", "d", "Place, publisher, and date of publication", "NR", "g", "Related parts", "R", "h", "Physical description", "NR", "i", "Relationship information", "R", "k", "Series data for related item", "R", "m", "Material-specific details", "NR", "n", "Note", "R", "o", "Other item identifier", "R", "r", "Report number", "R", "s", "Uniform title", "NR", "t", "Title", "NR", "u", "Standard Technical Report Number", "NR", "w", "Record control number", "R", "x", "International Standard Serial Number", "NR", "y", "CODEN designation", "NR", "z", "International Standard Book Number", "R", "4", "Relationship", "R", "6", "Linkage", "NR", "7", "Control subfield", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("4").setCodeList(RelatorCodes.getInstance());
        this.getSubfield("7").setPositions(Tag76xSubfield7PositionsGenerator.getPositions());
        this.getSubfield("z").setValidator(ISBNValidator.getInstance());
        this.getSubfield("x").setValidator(ISSNValidator.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setCompilanceLevels("A", "A");
        this.getSubfield("b").setBibframeTag("editionStatement").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("c").setBibframeTag("qualifier").setCompilanceLevels("A");
        this.getSubfield("d").setBibframeTag("provisionActivityStatement").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("g").setBibframeTag("part").setCompilanceLevels("A");
        this.getSubfield("h").setBibframeTag("extent").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("i").setBibframeTag("relation").setCompilanceLevels("O");
        this.getSubfield("k").setBibframeTag("seriesStatement").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("m").setBibframeTag("note").setMqTag("materialSpecificDetails").setCompilanceLevels("O");
        this.getSubfield("n").setBibframeTag("note").setCompilanceLevels("O");
        this.getSubfield("o").setMqTag("otherItemIdentifier").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("r").setMqTag("reportNumber").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("s").setBibframeTag("title").setMqTag("uniformTitle").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A", "A");
        this.getSubfield("t").setBibframeTag("title").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("u").setBibframeTag("strn").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("w").setMqTag("recordControlNumber").setFrbrFunctions(FRBRFunction.ManagementIdentify).setCompilanceLevels("A");
        this.getSubfield("x").setBibframeTag("issn").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("y").setBibframeTag("coden").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("z").setBibframeTag("isbn").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("4").setMqTag("relationship").setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("7").setMqTag("controlSubfield").setCompilanceLevels("O");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

