/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags70x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.TaxonomicClassificationSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;

public class Tag754
extends DataFieldDefinition {
    private static Tag754 uniqueInstance;

    private Tag754() {
        this.initialize();
        this.postCreation();
    }

    public static Tag754 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag754();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "754";
        this.label = "Added Entry - Taxonomic Identification";
        this.mqTag = "TaxonomicIdentification";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd754.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Taxonomic name", "R", "c", "Taxonomic category", "R", "d", "Common or alternative name", "R", "x", "Non-public note", "R", "z", "Public note", "R", "0", "Authority record control number", "R", "2", "Source of taxonomic identification", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(TaxonomicClassificationSourceCodes.getInstance());
        this.getSubfield("0").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("name").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("c").setMqTag("category").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("d").setMqTag("commonOrAlternativeName").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("x").setMqTag("nonPublicNote").setCompilanceLevels("O");
        this.getSubfield("z").setMqTag("publicNote").setCompilanceLevels("O");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setCompilanceLevels("O");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("M");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.sourceSpecificationType = SourceSpecificationType.Subfield2;
    }
}

