/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags6xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.CurriculumObjectiveTermAndCodeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag658
extends DataFieldDefinition {
    private static Tag658 uniqueInstance;

    private Tag658() {
        this.initialize();
        this.postCreation();
    }

    public static Tag658 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag658();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "658";
        this.label = "Index Term - Curriculum Objective";
        this.mqTag = "CurriculumObjective";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd658.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Main curriculum objective", "NR", "b", "Subordinate curriculum objective", "R", "c", "Curriculum code", "NR", "d", "Correlation factor", "NR", "2", "Source of term or code", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(CurriculumObjectiveTermAndCodeSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("main").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("subordinate").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("code").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("correlationFactor").setCompilanceLevels("A");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("M");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.fieldIndexer = SchemaFromSubfield2.getInstance();
        this.sourceSpecificationType = SourceSpecificationType.Subfield2;
    }
}

