/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags6xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.FunctionTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd2AndSubfield2;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;

public class Tag657
extends DataFieldDefinition {
    private static Tag657 uniqueInstance;

    private Tag657() {
        this.initialize();
        this.postCreation();
    }

    public static Tag657 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag657();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "657";
        this.label = "Index Term - Function";
        this.mqTag = "Function";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd657.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator("Source of term").setCodes("7", "Source specified in subfield $2").setMqTag("sourceOfTerm").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Function", "NR", "v", "Form subdivision", "R", "x", "General subdivision", "R", "y", "Chronological subdivision", "R", "z", "Geographic subdivision", "R", "0", "Authority record control number", "R", "2", "Source of term", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(FunctionTermSourceCodes.getInstance());
        this.getSubfield("0").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("v").setBibframeTag("formGenre").setMqTag("formSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("x").setBibframeTag("topic").setMqTag("generalSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("y").setBibframeTag("temporal").setMqTag("chronologicalSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("z").setBibframeTag("geographic").setMqTag("geographicSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setCompilanceLevels("O");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("M");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.fieldIndexer = SchemaFromInd2AndSubfield2.getInstance();
        this.sourceSpecificationType = SourceSpecificationType.Indicator2AndSubfield2;
    }
}

