/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags6xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.GenreFormCodeAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd2AndSubfield2;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;

public class Tag655
extends DataFieldDefinition {
    private static Tag655 uniqueInstance;

    private Tag655() {
        this.initialize();
        this.postCreation();
    }

    public static Tag655 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag655();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "655";
        this.label = "Index Term - Genre/Form";
        this.bibframeTag = "GenreForm";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd655.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Type of heading").setCodes(" ", "Basic", "0", "Faceted").setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator("Thesaurus").setCodes("0", "Library of Congress Subject Headings", "1", "LC subject headings for children's literature", "2", "Medical Subject Headings", "3", "National Agricultural Library subject authority file", "4", "Source not specified", "5", "Canadian Subject Headings", "6", "R\u00e9pertoire de vedettes-mati\u00e8re", "7", "Source specified in subfield $2").setMqTag("thesaurus").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Genre/form data or focus term", "NR", "b", "Non-focus term", "R", "c", "Facet/hierarchy designation", "R", "v", "Form subdivision", "R", "x", "General subdivision", "R", "y", "Chronological subdivision", "R", "z", "Geographic subdivision", "R", "0", "Authority record control number", "R", "2", "Source of term", "NR", "3", "Materials specified", "NR", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(GenreFormCodeAndTermSourceCodes.getInstance());
        this.getSubfield("0").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("nonfocusTerm").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("c").setMqTag("facet").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("M");
        this.getSubfield("v").setBibframeTag("genreForm").setMqTag("formSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("x").setBibframeTag("topic").setMqTag("generalSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("y").setBibframeTag("temporal").setMqTag("chronologicalSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("z").setBibframeTag("geographic").setMqTag("geographicSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setCompilanceLevels("O");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.fieldIndexer = SchemaFromInd2AndSubfield2.getInstance();
        this.sourceSpecificationType = SourceSpecificationType.Indicator2AndSubfield2;
    }
}

