/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags6xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd2AndSubfield2;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag647
extends DataFieldDefinition {
    private static Tag647 uniqueInstance;

    private Tag647() {
        this.initialize();
        this.postCreation();
    }

    public static Tag647 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag647();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "647";
        this.label = "Subject Added Entry - Named Event";
        this.mqTag = "NamedEvent";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd647.html";
        this.ind1 = new Indicator();
        this.ind2 = new Indicator("Thesaurus").setCodes("0", "Library of Congress Subject Headings", "1", "LC subject headings for children's literature", "2", "Medical Subject Headings", "3", "National Agricultural Library subject authority file", "4", "Source not specified", "5", "Canadian Subject Headings", "6", "R\u00e9pertoire de vedettes-mati\u00e8re", "7", "Source specified in subfield $2").setMqTag("thesaurus");
        this.setSubfieldsWithCardinality("a", "Named event", "NR", "c", "Location of named event", "R", "d", "Date of named event", "NR", "g", "Miscellaneous information", "R", "v", "Form subdivision", "R", "x", "General subdivision", "R", "y", "Chronological subdivision", "R", "z", "Geographic subdivision", "R", "0", "Authority record control number or standard number", "R", "2", "Source of heading or term", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value");
        this.getSubfield("c").setMqTag("location");
        this.getSubfield("d").setMqTag("date");
        this.getSubfield("g").setMqTag("miscellaneous");
        this.getSubfield("v").setBibframeTag("formGenre").setMqTag("formSubdivision");
        this.getSubfield("x").setBibframeTag("topic").setMqTag("generalSubdivision");
        this.getSubfield("y").setBibframeTag("temporal").setMqTag("chronologicalSubdivision");
        this.getSubfield("z").setBibframeTag("geographic").setMqTag("geographicSubdivision");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber");
        this.getSubfield("2").setMqTag("source");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("6").setBibframeTag("linkage");
        this.getSubfield("8").setMqTag("fieldLink");
        this.fieldIndexer = SchemaFromInd2AndSubfield2.getInstance();
        this.sourceSpecificationType = SourceSpecificationType.Indicator2AndSubfield2;
    }
}

