/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.ResourceActionTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag583
extends DataFieldDefinition {
    private static Tag583 uniqueInstance;

    private Tag583() {
        this.initialize();
        this.postCreation();
    }

    public static Tag583 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag583();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "583";
        this.label = "Action Note";
        this.mqTag = "Action";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd583.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Privacy").setCodes(" ", "No information provided", "0", "Private", "1", "Not private").setMqTag("privacy");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Action", "NR", "b", "Action identification", "R", "c", "Time/date of action", "R", "d", "Action interval", "R", "e", "Contingency for action", "R", "f", "Authorization", "R", "h", "Jurisdiction", "R", "i", "Method of action", "R", "j", "Site of action", "R", "k", "Action agent", "R", "l", "Status", "R", "n", "Extent", "R", "o", "Type of unit", "R", "u", "Uniform Resource Identifier", "R", "x", "Nonpublic note", "R", "z", "Public note", "R", "2", "Source of term", "NR", "3", "Materials specified", "NR", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(ResourceActionTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("identification").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("timeOrDate").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("interval").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("contingency").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("authorization").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("jurisdiction").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("i").setMqTag("method").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("site").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("k").setBibframeTag("agent").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("l").setBibframeTag("status").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("extent").setCompilanceLevels("A");
        this.getSubfield("o").setMqTag("typeOfUnit").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("u").setMqTag("uri").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("x").setMqTag("nonpublicNote").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("z").setBibframeTag("publicNote").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

